/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NLocal;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.jayce.v0003.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NCatchBlock
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.CATCH_BLOCK;
    @CheckForNull
    public String id;
    @Nonnull
    protected List<NStatement> statements = Collections.emptyList();
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;
    @Nonnull
    public List<String> catchTypes = Collections.emptyList();
    @CheckForNull
    public NLocal catchVar;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JCatchBlock catchBlock = (JCatchBlock)node;
        this.id = loader.getCatchBlockSymbols().getId(catchBlock);
        this.catchTypes = ImportHelper.getSignatureNameList(catchBlock.getCatchTypes());
        this.catchVar = (NLocal)loader.load(catchBlock.getCatchVar());
        this.statements = loader.load(NStatement.class, catchBlock.getStatements());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), catchBlock.getJCatchBlocks());
        this.sourceInfo = loader.load(catchBlock.getSourceInfo());
    }

    @Override
    @Nonnull
    public JCatchBlock exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        ArrayList<JClass> jCatchTypes = new ArrayList<JClass>(this.catchTypes.size());
        for (String catchedType : this.catchTypes) {
            jCatchTypes.add(exportSession.getLookup().getClass(catchedType));
        }
        assert (this.catchVar != null);
        JLocal jCatchVar = this.catchVar.exportAsJast(exportSession);
        JCatchBlock jCatchBlock = new JCatchBlock(this.sourceInfo.exportAsJast(exportSession), jCatchTypes, jCatchVar);
        for (NStatement nStatement : this.statements) {
            jCatchBlock.addStmt(nStatement.exportAsJast(exportSession));
        }
        String id = this.id;
        assert (id != null);
        exportSession.getCatchBlockResolver().addTarget(id, jCatchBlock);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jCatchBlock));
        }
        return jCatchBlock;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.id = in.readId();
        this.catchTypes = in.readIds();
        this.catchVar = in.readNode(NLocal.class);
        this.statements = in.readNodes(NStatement.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

