/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JConcatOperation;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NConcatOperation
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.CONCAT_OPERATION;
    @Nonnull
    private static final String JAVA_LANG_STRING = "Ljava/lang/String;";
    @CheckForNull
    public NExpression lhs;
    @CheckForNull
    public NExpression rhs;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JConcatOperation concat = (JConcatOperation)node;
        this.lhs = (NExpression)loader.load(concat.getLhs());
        this.rhs = (NExpression)loader.load(concat.getRhs());
        this.sourceInfo = loader.load(concat.getSourceInfo());
    }

    @Override
    @Nonnull
    public JConcatOperation exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.lhs != null);
        assert (this.rhs != null);
        return new JConcatOperation(this.sourceInfo.exportAsJast(exportSession), exportSession.getLookup().getClass(JAVA_LANG_STRING), this.lhs.exportAsJast(exportSession), this.rhs.exportAsJast(exportSession));
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.lhs = in.readNode(NExpression.class);
        this.rhs = in.readNode(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

