/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NDynamicCastOperation
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.DYNAMIC_CAST_OPERATION;
    @CheckForNull
    public List<String> castTypes;
    @CheckForNull
    public NExpression expr;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDynamicCastOperation jMultiCastOperation = (JDynamicCastOperation)node;
        this.castTypes = ImportHelper.getSignatureNameList(jMultiCastOperation.getTypes());
        this.expr = (NExpression)loader.load(jMultiCastOperation.getExpr());
        this.sourceInfo = loader.load(jMultiCastOperation.getSourceInfo());
    }

    @Override
    @Nonnull
    public JDynamicCastOperation exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.castTypes != null);
        assert (this.expr != null);
        ArrayList<JType> jTypes = new ArrayList<JType>(this.castTypes.size());
        for (String types : this.castTypes) {
            jTypes.add(exportSession.getLookup().getType(types));
        }
        JExpression jExpr = this.expr.exportAsJast(exportSession);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JDynamicCastOperation castOperation = new JDynamicCastOperation(jSourceInfo, jExpr, jTypes);
        return castOperation;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.castTypes = in.readIds();
        this.expr = in.readNode(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

