/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0003.NNode;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NFieldRef
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.FIELD_REF;
    @CheckForNull
    public String field;
    @CheckForNull
    public String fieldType;
    @CheckForNull
    public String receiverType;
    @CheckForNull
    public FieldKind kind;
    @CheckForNull
    public NExpression instance;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JFieldRef jFieldRef = (JFieldRef)node;
        this.field = jFieldRef.getFieldId().getName();
        this.fieldType = NNode.getFormatter().getName(jFieldRef.getFieldId().getType());
        this.receiverType = ImportHelper.getSignatureName(jFieldRef.getReceiverType());
        this.kind = jFieldRef.getFieldId().getKind();
        this.instance = (NExpression)loader.load(jFieldRef.getInstance());
        this.sourceInfo = loader.load(jFieldRef.getSourceInfo());
    }

    @Override
    @Nonnull
    public JFieldRef exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.receiverType != null);
        assert (this.field != null);
        assert (this.fieldType != null);
        assert (this.kind != null);
        JExpression jInstance = this.instance != null ? this.instance.exportAsJast(exportSession) : null;
        JType jReceiverType = exportSession.getLookup().getType(this.receiverType);
        JType jFieldType = exportSession.getLookup().getType(this.fieldType);
        return new JFieldRef(this.sourceInfo.exportAsJast(exportSession), jInstance, exportSession.getFieldId((JClassOrInterface)jReceiverType, this.field, jFieldType, this.kind), (JClassOrInterface)jReceiverType);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.field = in.readId();
        this.fieldType = in.readId();
        this.receiverType = in.readId();
        this.kind = in.readFieldRefKindEnum();
        this.instance = in.readNode(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

