/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NAnnotation;
import com.android.jack.jayce.v0003.nodes.NDeclaredType;
import com.android.jack.jayce.v0003.nodes.NField;
import com.android.jack.jayce.v0003.nodes.NMarker;
import com.android.jack.jayce.v0003.nodes.NMethod;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.util.NamingTools;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NInterfaceType
extends NDeclaredType {
    @Nonnull
    public static final Token TOKEN = Token.INTERFACE;
    public int modifiers;
    @CheckForNull
    public String signature;
    @Nonnull
    public List<String> superInterfaces = Collections.emptyList();
    @CheckForNull
    public String enclosingType;
    @Nonnull
    public List<String> inners = Collections.emptyList();
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDefinedInterface jInterfaceType = (JDefinedInterface)node;
        this.modifiers = jInterfaceType.getModifier();
        this.signature = ImportHelper.getSignatureName(jInterfaceType);
        this.superInterfaces = ImportHelper.getSignatureNameList(jInterfaceType.getImplements());
        this.enclosingType = ImportHelper.getSignatureName(jInterfaceType.getEnclosingType());
        this.inners = ImportHelper.getSignatureNameList(jInterfaceType.getMemberTypes());
        this.setFields(loader.load(NField.class, jInterfaceType.getFields()));
        this.setMethods(loader.load(NMethod.class, jInterfaceType.getMethods()));
        this.annotations = loader.load(NAnnotation.class, jInterfaceType.getAnnotations());
        this.markers = loader.load(NMarker.class, jInterfaceType.getAllMarkers());
        this.sourceInfo = loader.load(jInterfaceType.getSourceInfo());
    }

    @Override
    @Nonnull
    public JDefinedInterface exportAsJast(@Nonnull ExportSession exportSession) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public JDefinedInterface create(@Nonnull JPackage enclosingPackage, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.signature != null);
        String binaryName = NamingTools.getClassBinaryNameFromDescriptor(this.signature);
        String simpleName = NamingTools.getSimpleClassNameFromBinaryName(binaryName);
        JDefinedInterface jInterfaceType = new JDefinedInterface(SourceInfo.UNKNOWN, simpleName, this.modifiers, enclosingPackage, loader);
        return jInterfaceType;
    }

    @Override
    public void loadStructure(@Nonnull JDefinedClassOrInterface loading, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.sourceInfo != null);
        assert (this.signature != null);
        JDefinedInterface jInterfaceType = (JDefinedInterface)loading;
        ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
        exportSession.setCurrentType(jInterfaceType);
        loading.setSourceInfo(this.sourceInfo.exportAsJast(exportSession));
        for (String superInterface : this.superInterfaces) {
            jInterfaceType.addImplements(exportSession.getLookup().getInterface(superInterface));
        }
        if (this.enclosingType != null) {
            jInterfaceType.setEnclosingType((JClassOrInterface)exportSession.getLookup().getType(this.enclosingType));
        }
        for (String memberType : this.inners) {
            jInterfaceType.addMemberType((JClassOrInterface)exportSession.getLookup().getType(memberType));
        }
        for (NField field : this.getFields()) {
            JField jField = field.exportAsJast(exportSession, loader);
            jField.setEnclosingType(jInterfaceType);
            jInterfaceType.addField(jField);
        }
        for (NMethod method : this.getMethods()) {
            JMethod jMethod = method.exportAsJast(exportSession, loader);
            jInterfaceType.addMethod(jMethod);
        }
        for (NMarker marker : this.markers) {
            jInterfaceType.addMarker(marker.exportAsJast(exportSession));
        }
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.level = in.getNodeLevel();
        this.modifiers = in.readInt();
        this.signature = in.readId();
        if (this.level != NodeLevel.TYPES) {
            this.superInterfaces = in.readIds();
            this.enclosingType = in.readId();
            this.inners = in.readIds();
            this.setFields(in.readNodes(NField.class));
            this.setMethods(in.readNodes(NMethod.class));
            this.annotations = in.readNodes(NAnnotation.class);
            this.markers = in.readNodes(NMarker.class);
        }
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public String getSignature() {
        assert (this.signature != null);
        return this.signature;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

