/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodLiteral;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NLiteral;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NMethodLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.METHOD_LITERAL;
    @CheckForNull
    public String method;
    @CheckForNull
    public String methodEnclosingType;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JMethodLiteral jMethodLiteral = (JMethodLiteral)node;
        this.method = ImportHelper.getMethodSignature(jMethodLiteral.getMethod());
        this.methodEnclosingType = ImportHelper.getSignatureName(jMethodLiteral.getMethod().getEnclosingType());
        this.sourceInfo = loader.load(jMethodLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JMethodLiteral exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.methodEnclosingType != null);
        assert (this.method != null);
        JDefinedClassOrInterface jEnclosingType = (JDefinedClassOrInterface)exportSession.getLookup().getType(this.methodEnclosingType);
        JMethod jMethod = exportSession.getDeclaredMethod(jEnclosingType, this.method);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JMethodLiteral jMethodLiteral = new JMethodLiteral(jMethod, jSourceInfo);
        return jMethodLiteral;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.method = in.readId();
        this.methodEnclosingType = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

