/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NMethodCall;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.Nonnull;

public class NNewInstance
extends NMethodCall {
    @Nonnull
    public static final Token TOKEN = Token.NEW_INSTANCE;
    @Nonnull
    public static final String INIT_NAME = "<init>";

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JNewInstance jNewInstance = (JNewInstance)node;
        this.receiverType = ImportHelper.getSignatureName(jNewInstance.getReceiverType());
        this.methodArgsType = ImportHelper.getMethodArgsSignature(jNewInstance.getMethodIdWide());
        this.args = loader.load(NExpression.class, jNewInstance.getArgs());
        this.sourceInfo = loader.load(jNewInstance.getSourceInfo());
    }

    @Override
    @Nonnull
    public JNewInstance exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.instance == null);
        assert (this.dispatchKind == null);
        assert (this.methodName == null);
        assert (this.methodKind == null);
        assert (this.sourceInfo != null);
        assert (this.receiverType != null);
        assert (this.methodArgsType != null);
        assert (this.args != null);
        JClass jReceiverType = exportSession.getLookup().getClass(this.receiverType);
        JMethodId methodId = jReceiverType.getOrCreateMethodId(INIT_NAME, exportSession.getTypeListFromSignatureList(this.methodArgsType), MethodKind.INSTANCE_NON_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JNewInstance jNewInstance = new JNewInstance(jSourceInfo, jReceiverType, methodId);
        for (NExpression arg : this.args) {
            jNewInstance.addArg(arg.exportAsJast(exportSession));
        }
        return jNewInstance;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.receiverType = in.readId();
        this.methodArgsType = in.readIds();
        this.args = in.readNodes(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

