/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.JayceMethodLoader;
import com.android.jack.jayce.JayceParameterLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.ParameterNode;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NAnnotation;
import com.android.jack.jayce.v0003.nodes.NMarker;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.jayce.v0003.nodes.NVariable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NParameter
extends NVariable
implements ParameterNode {
    @Nonnull
    public static final Token TOKEN = Token.PARAMETER;
    protected static final int INDEX_UNKNOWN = -1;
    @CheckForNull
    public String id;
    public int modifiers;
    @CheckForNull
    public String type;
    @CheckForNull
    public String name;
    @Nonnull
    public List<NAnnotation> annotations = Collections.emptyList();
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;
    protected int parameterNodeIndex = -1;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JParameter jParameter = (JParameter)node;
        this.id = loader.getVariableSymbols().getId(jParameter);
        this.modifiers = jParameter.getModifier();
        this.type = ImportHelper.getSignatureName(jParameter.getType());
        this.name = jParameter.getName();
        this.annotations = loader.load(NAnnotation.class, jParameter.getAnnotations());
        this.markers = loader.load(NMarker.class, jParameter.getAllMarkers());
        this.sourceInfo = loader.load(jParameter.getSourceInfo());
    }

    @Override
    @Nonnull
    public JParameter exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public JParameter exportAsJast(@Nonnull ExportSession exportSession, @Nonnull JayceMethodLoader enclosingMethodLoader) throws JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.type != null);
        assert (this.name != null);
        JParameter jParameter = new JParameter(this.sourceInfo.exportAsJast(exportSession), this.name, exportSession.getLookup().getType(this.type), this.modifiers, exportSession.getCurrentMethod(), new JayceParameterLoader(this, this.parameterNodeIndex, enclosingMethodLoader));
        NParameter.manageSynthetic(jParameter);
        assert (this.id != null);
        exportSession.getVariableResolver().addTarget(this.id, jParameter);
        for (NMarker marker : this.markers) {
            jParameter.addMarker(marker.exportAsJast(exportSession));
        }
        return jParameter;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.id = in.readId();
        this.modifiers = in.readInt();
        this.type = in.readId();
        this.name = in.readId();
        this.annotations = in.readNodes(NAnnotation.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setIndex(@Nonnegative int index) {
        this.parameterNodeIndex = index;
    }

    @Override
    public void loadAnnotations(@Nonnull JParameter loading, @Nonnull JayceParameterLoader loader) {
        if (!this.annotations.isEmpty()) {
            ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
            for (NAnnotation annotation : this.annotations) {
                JAnnotation annote = annotation.exportAsJast(exportSession);
                loading.addAnnotation(annote);
                annote.updateParents(loading);
            }
        }
    }
}

