/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NThisRef
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.THIS_REF;
    @CheckForNull
    public String type;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JThisRef jThisRef = (JThisRef)node;
        this.type = ImportHelper.getSignatureName(jThisRef.getType());
        this.sourceInfo = loader.load(jThisRef.getSourceInfo());
    }

    @Override
    @Nonnull
    public JThisRef exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.type != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JThis jThis = exportSession.getCurrentMethod().getThis();
        assert (jThis != null);
        JThisRef jThisRef = jThis.makeRef(jSourceInfo);
        return jThisRef;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.type = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

