/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.io;

import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.linker.SymbolResolver;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.lookup.JPhantomLookup;
import com.android.sched.util.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ExportSession {
    @Nonnull
    private final SymbolResolver<JCatchBlock> catchBlockResolver = new SymbolResolver();
    @Nonnull
    private final SymbolResolver<JField> fieldInitializerFieldResolver = new SymbolResolver();
    @Nonnull
    private final SymbolResolver<JLabeledStatement> labelResolver = new SymbolResolver();
    @Nonnull
    private final SymbolResolver<JVariable> variableResolver;
    @Nonnull
    private final SymbolResolver<JCaseStatement> caseResolver = new SymbolResolver();
    @Nonnull
    private final JPhantomLookup lookup;
    @Nonnull
    private final NodeLevel nodeLevel;
    @CheckForNull
    private JDefinedClassOrInterface currentType;
    @CheckForNull
    private JMethod currentMethod;
    @Nonnull
    private final JSession session;

    public ExportSession(@Nonnull JSession session, @Nonnull NodeLevel nodeLevel) {
        this.session = session;
        this.lookup = session.getPhantomLookup();
        this.nodeLevel = nodeLevel;
        this.variableResolver = new SymbolResolver();
    }

    @Nonnull
    public JPhantomLookup getLookup() {
        return this.lookup;
    }

    @Nonnull
    public NodeLevel getNodeLevel() {
        return this.nodeLevel;
    }

    public void setCurrentType(@CheckForNull JDefinedClassOrInterface currentType) {
        this.currentType = currentType;
    }

    public void setCurrentMethod(@CheckForNull JMethod currentMethod) {
        this.currentMethod = currentMethod;
    }

    @Nonnull
    public JDefinedClassOrInterface getCurrentType() {
        assert (this.currentType != null);
        return this.currentType;
    }

    @Nonnull
    public JMethod getCurrentMethod() {
        assert (this.currentMethod != null);
        return this.currentMethod;
    }

    @Nonnull
    public JSession getSession() {
        return this.session;
    }

    @Nonnull
    public SymbolResolver<JCaseStatement> getCaseResolver() {
        return this.caseResolver;
    }

    @Nonnull
    public SymbolResolver<JCatchBlock> getCatchBlockResolver() {
        return this.catchBlockResolver;
    }

    @Nonnull
    public SymbolResolver<JField> getFieldInitializerFieldResolver() {
        return this.fieldInitializerFieldResolver;
    }

    @Nonnull
    public SymbolResolver<JLabeledStatement> getLabelResolver() {
        return this.labelResolver;
    }

    @Nonnull
    public SymbolResolver<JVariable> getVariableResolver() {
        return this.variableResolver;
    }

    @Nonnull
    public List<JType> getTypeListFromSignatureList(@Nonnull List<String> typeSignatures) throws JTypeLookupException {
        List<JType> argsType = typeSignatures.isEmpty() ? Lists.create() : new ArrayList(typeSignatures.size());
        for (String signature : typeSignatures) {
            argsType.add(this.lookup.getType(signature));
        }
        return argsType;
    }

    @Nonnull
    public JMethod getDeclaredMethod(@Nonnull JDefinedClassOrInterface receiver, @Nonnull String methodsignature) throws JMethodLookupException, JTypeLookupException {
        int argStart = methodsignature.indexOf(40);
        int argEnd = methodsignature.indexOf(41);
        assert (argStart > 0 && argEnd > 0 && argStart < argEnd && argStart == methodsignature.lastIndexOf(40) && argEnd == methodsignature.lastIndexOf(41) && argEnd + 1 < methodsignature.length());
        String methodName = methodsignature.substring(0, argStart);
        String argsTypeSignatures = methodsignature.substring(argStart + 1, argEnd);
        String returnSignature = methodsignature.substring(argEnd + 1);
        return receiver.getMethod(methodName, this.lookup.getType(returnSignature), this.getTypeList(argsTypeSignatures));
    }

    @Nonnull
    private List<JType> getTypeList(@Nonnull String argsTypeSignatures) throws JTypeLookupException {
        ArrayList<JType> argsType = new ArrayList<JType>();
        int len = argsTypeSignatures.length();
        int arrayDim = 0;
        for (int index = 0; index < len; ++index) {
            JType type = null;
            switch (argsTypeSignatures.charAt(index)) {
                case '[': {
                    ++arrayDim;
                    break;
                }
                case 'L': {
                    int signatureEnd = argsTypeSignatures.indexOf(59, index);
                    type = this.lookup.getType(argsTypeSignatures.substring(index, signatureEnd + 1));
                    index = signatureEnd;
                    break;
                }
                case 'V': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.VOID.getType();
                    break;
                }
                case 'Z': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType();
                    break;
                }
                case 'B': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType();
                    break;
                }
                case 'C': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType();
                    break;
                }
                case 'S': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType();
                    break;
                }
                case 'I': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.INT.getType();
                    break;
                }
                case 'J': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.LONG.getType();
                    break;
                }
                case 'F': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType();
                    break;
                }
                case 'D': {
                    type = JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (type == null) continue;
            for (int i = 0; i < arrayDim; ++i) {
                type = type.getArray();
            }
            arrayDim = 0;
            argsType.add(type);
        }
        return argsType;
    }

    @Nonnull
    public JFieldId getFieldId(@Nonnull JClassOrInterface receiver, @Nonnull String fieldName, @Nonnull JType fieldType, @Nonnull FieldKind kind) {
        return receiver.getOrCreateFieldId(fieldName, fieldType, kind);
    }
}

