/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NConditionalExpression
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.CONDITIONAL_EXPRESSION;
    @CheckForNull
    public NExpression ifTest;
    @CheckForNull
    public NExpression thenExpr;
    @CheckForNull
    public NExpression elseExpr;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JConditionalExpression jConditionalExpression = (JConditionalExpression)node;
        this.ifTest = (NExpression)loader.load(jConditionalExpression.getIfTest());
        this.thenExpr = (NExpression)loader.load(jConditionalExpression.getThenExpr());
        this.elseExpr = (NExpression)loader.load(jConditionalExpression.getElseExpr());
        this.sourceInfo = jConditionalExpression.getSourceInfo();
    }

    @Override
    @Nonnull
    public JConditionalExpression exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.ifTest != null);
        assert (this.thenExpr != null);
        assert (this.elseExpr != null);
        JExpression jIf = this.ifTest.exportAsJast(exportSession);
        JExpression jThen = this.thenExpr.exportAsJast(exportSession);
        JExpression jElse = this.elseExpr.exportAsJast(exportSession);
        JConditionalExpression jConditionalExpression = new JConditionalExpression(this.sourceInfo, jIf, jThen, jElse);
        return jConditionalExpression;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.ifTest);
        out.writeNode(this.thenExpr);
        out.writeNode(this.elseExpr);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.ifTest = in.readNode(NExpression.class);
        this.thenExpr = in.readNode(NExpression.class);
        this.elseExpr = in.readNode(NExpression.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipNode();
        in.skipNode();
        in.skipNode();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

