/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.debug.DebugVariableInfoMarker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NMarker;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NDebugVariableInfo
extends NMarker {
    @Nonnull
    public static final Token TOKEN = Token.DEBUG_VARIABLE_INFORMATION;
    @CheckForNull
    public String name;
    @CheckForNull
    public String type;
    @CheckForNull
    public String genericSignature;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        DebugVariableInfoMarker debugVarInfo = (DebugVariableInfoMarker)node;
        this.name = debugVarInfo.getName();
        this.type = ImportHelper.getSignatureName(debugVarInfo.getType());
        this.genericSignature = debugVarInfo.getGenericSignature();
    }

    @Override
    @Nonnull
    public DebugVariableInfoMarker exportAsJast(@Nonnull ExportSession exportSession) {
        if (this.name == null && this.type == null) {
            return DebugVariableInfoMarker.NO_DEBUG_INFO;
        }
        assert (this.name != null);
        assert (this.type != null);
        return new DebugVariableInfoMarker(this.name, exportSession.getLookup().getType(this.type), this.genericSignature);
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeString(this.name);
        out.writeId(this.type);
        out.writeString(this.genericSignature);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.name = in.readString();
        this.type = in.readId();
        this.genericSignature = in.readString();
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipString();
        in.skipId();
        in.skipString();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

