/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JLabeledStatementUnresolved;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.linker.GotoLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NStatement;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NGoto
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.GOTO;
    @CheckForNull
    public String target;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JGoto jGoto = (JGoto)node;
        this.target = loader.getLabelSymbols().getId(jGoto.getTargetBlock());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jGoto.getJCatchBlocks());
        this.sourceInfo = jGoto.getSourceInfo();
    }

    @Override
    @Nonnull
    public JGoto exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.target != null);
        JGoto jGoto = new JGoto(this.sourceInfo, JLabeledStatementUnresolved.INSTANCE);
        exportSession.getLabelResolver().addLink(this.target, new GotoLinker(jGoto));
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jGoto));
        }
        return jGoto;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.target);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.target = in.readId();
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

