/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdRef;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NMarker;
import com.android.jack.jayce.v0004.nodes.NMethodCall;
import com.android.jack.jayce.v0004.nodes.NMethodId;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NLambda
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.LAMBDA;
    @Nonnull
    private List<NExpression> capturedVariables = Collections.emptyList();
    @CheckForNull
    public String methodRefType;
    @CheckForNull
    public String methodRefName;
    @Nonnull
    public List<String> methodRefArgsType = Collections.emptyList();
    @CheckForNull
    public MethodKind methodRefKind;
    @CheckForNull
    private String typeSig;
    @Nonnull
    private List<String> boundsIds = Collections.emptyList();
    @CheckForNull
    private NMethodId mthIdWithErasure;
    @CheckForNull
    private NMethodId mthIdWithoutErasure;
    @CheckForNull
    public String enclosingType;
    @CheckForNull
    public NMethodCall.ReceiverKind receiverKind;
    @Nonnull
    private List<NMethodId> bridges = Collections.emptyList();
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JLambda lambda = (JLambda)node;
        this.capturedVariables = loader.load(NExpression.class, lambda.getCapturedVariables());
        JMethodIdRef methodIdRef = lambda.getMethodIdRef();
        this.methodRefName = methodIdRef.getMethodId().getMethodIdWide().getName();
        this.methodRefArgsType = ImportHelper.getMethodArgsSignature(methodIdRef.getMethodId().getMethodIdWide());
        this.methodRefKind = methodIdRef.getMethodId().getMethodIdWide().getKind();
        this.methodRefType = ImportHelper.getSignatureName(methodIdRef.getMethodId().getType());
        this.enclosingType = ImportHelper.getSignatureName(methodIdRef.getEnclosingType());
        this.receiverKind = methodIdRef.getEnclosingType() instanceof JClass ? NMethodCall.ReceiverKind.CLASS : NMethodCall.ReceiverKind.INTERFACE;
        this.typeSig = ImportHelper.getSignatureName(lambda.getType());
        this.sourceInfo = lambda.getSourceInfo();
        this.boundsIds = ImportHelper.getSignatureNameList(lambda.getInterfaceBounds());
        this.mthIdWithErasure = (NMethodId)loader.load(lambda.getMethodIdWithErasure());
        this.mthIdWithoutErasure = (NMethodId)loader.load(lambda.getMethodIdWithoutErasure());
        this.bridges = loader.load(NMethodId.class, lambda.getBridgeMethodIds());
        this.markers = loader.load(NMarker.class, lambda.getAllMarkers());
    }

    @Override
    @Nonnull
    public JExpression exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.capturedVariables != null);
        assert (this.methodRefName != null);
        assert (this.methodRefKind != null);
        assert (this.methodRefArgsType != null);
        assert (this.typeSig != null);
        assert (this.mthIdWithErasure != null);
        assert (this.mthIdWithoutErasure != null);
        assert (this.receiverKind != null);
        assert (this.enclosingType != null);
        assert (this.methodRefType != null);
        JClassOrInterface jEnclosingType = this.receiverKind == NMethodCall.ReceiverKind.CLASS ? exportSession.getLookup().getClass(this.enclosingType) : exportSession.getLookup().getInterface(this.enclosingType);
        JMethodId methodId = jEnclosingType.getOrCreateMethodId(this.methodRefName, exportSession.getTypeListFromSignatureList(this.methodRefArgsType), this.methodRefKind, exportSession.getLookup().getType(this.methodRefType));
        ArrayList<JInterface> jBounds = new ArrayList<JInterface>(this.boundsIds.size());
        for (String bound : this.boundsIds) {
            jBounds.add(exportSession.getLookup().getInterface(bound));
        }
        JInterface lambdaType = exportSession.getLookup().getInterface(this.typeSig);
        JMethodId unlinkedMthId = (JMethodId)this.mthIdWithErasure.exportAsJast(exportSession);
        JMethodId mthIdToImplements = lambdaType.getOrCreateMethodId(unlinkedMthId.getMethodIdWide().getName(), unlinkedMthId.getMethodIdWide().getParamTypes(), MethodKind.INSTANCE_VIRTUAL, unlinkedMthId.getType());
        JMethodId jmthIdToEnforce = (JMethodId)this.mthIdWithoutErasure.exportAsJast(exportSession);
        JLambda lambda = new JLambda(this.sourceInfo, mthIdToImplements, new JMethodIdRef(this.sourceInfo, (JDefinedClassOrInterface)jEnclosingType, methodId), lambdaType, jBounds, jmthIdToEnforce);
        for (NMethodId bridge : this.bridges) {
            lambda.addBridgeMethodId((JMethodId)bridge.exportAsJast(exportSession));
        }
        for (NExpression capturedVariable : this.capturedVariables) {
            JExpression jcapturedVariable = capturedVariable.exportAsJast(exportSession);
            lambda.addCapturedVariable(jcapturedVariable);
        }
        for (NMarker marker : this.markers) {
            lambda.addMarker(marker.exportAsJast(exportSession));
        }
        return lambda;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.methodRefKind != null);
        assert (this.receiverKind != null);
        out.writeNodes(this.capturedVariables);
        out.writeReceiverKindEnum(this.receiverKind);
        out.writeId(this.enclosingType);
        out.writeId(this.methodRefName);
        out.writeIds(this.methodRefArgsType);
        out.writeMethodKindEnum(this.methodRefKind);
        out.writeId(this.methodRefType);
        out.writeId(this.typeSig);
        out.writeIds(this.boundsIds);
        out.writeNode(this.mthIdWithErasure);
        out.writeNode(this.mthIdWithoutErasure);
        out.writeNodes(this.bridges);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.capturedVariables = in.readNodes(NExpression.class);
        this.receiverKind = in.readReceiverKindEnum();
        this.enclosingType = in.readId();
        this.methodRefName = in.readId();
        this.methodRefArgsType = in.readIds();
        this.methodRefKind = in.readMethodKindEnum();
        this.methodRefType = in.readId();
        this.typeSig = in.readId();
        this.boundsIds = in.readIds();
        this.mthIdWithErasure = in.readNode(NMethodId.class);
        this.mthIdWithoutErasure = in.readNode(NMethodId.class);
        this.bridges = in.readNodes(NMethodId.class);
        this.markers = in.readNodes(NMarker.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipNodes();
        in.skipReceiverKindEnum();
        in.skipId();
        in.skipId();
        in.skipIds();
        in.skipMethodKindEnum();
        in.skipId();
        in.skipId();
        in.skipIds();
        in.skipNode();
        in.skipNode();
        in.skipNodes();
        in.skipNodes();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

