/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodLiteral;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NLiteral;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NMethodLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.METHOD_LITERAL;
    @CheckForNull
    public String method;
    @CheckForNull
    public String methodEnclosingType;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JMethodLiteral jMethodLiteral = (JMethodLiteral)node;
        this.method = ImportHelper.getMethodSignature(jMethodLiteral.getMethod());
        this.methodEnclosingType = ImportHelper.getSignatureName(jMethodLiteral.getMethod().getEnclosingType());
        this.sourceInfo = jMethodLiteral.getSourceInfo();
    }

    @Override
    @Nonnull
    public JMethodLiteral exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.methodEnclosingType != null);
        assert (this.method != null);
        JDefinedClassOrInterface jEnclosingType = (JDefinedClassOrInterface)exportSession.getLookup().getType(this.methodEnclosingType);
        JMethod jMethod = exportSession.getDeclaredMethod(jEnclosingType, this.method);
        JMethodLiteral jMethodLiteral = new JMethodLiteral(jMethod, this.sourceInfo);
        return jMethodLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.method);
        out.writeId(this.methodEnclosingType);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.method = in.readId();
        this.methodEnclosingType = in.readId();
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipId();
        in.skipId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

