/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0004.NNode;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.HasSourceInfo;
import com.android.jack.jayce.v0004.nodes.NLiteral;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NNameValuePair
extends NNode
implements HasSourceInfo {
    @Nonnull
    public static final Token TOKEN = Token.NAME_VALUE_PAIR;
    @CheckForNull
    public String name;
    @CheckForNull
    public NLiteral value;
    @CheckForNull
    public SourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JNameValuePair jNameValuePair = (JNameValuePair)node;
        this.name = jNameValuePair.getName();
        this.value = (NLiteral)loader.load(jNameValuePair.getValue());
        assert (this.value != null);
        this.sourceInfo = jNameValuePair.getSourceInfo();
    }

    @Override
    @Nonnull
    public JNameValuePair exportAsJast(@Nonnull ExportSession exportSession) throws JMethodLookupException, JTypeLookupException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public JNameValuePair exportAsJast(@Nonnull ExportSession exportSession, @Nonnull JAnnotationType receiver) throws JMethodLookupException, JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.value != null);
        assert (this.name != null);
        JLiteral jValue = this.value.exportAsJast(exportSession);
        JMethodIdWide methodId = receiver.getOrCreateMethodIdWide(this.name, Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL);
        JNameValuePair jNameValuePair = new JNameValuePair(this.sourceInfo, methodId, jValue);
        return jNameValuePair;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeString(this.name);
        out.writeNode(this.value);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.name = in.readString();
        this.value = in.readNode(NLiteral.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipString();
        in.skipNode();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public SourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

