/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JParameterUnresolved;
import com.android.jack.jayce.linker.VariableRefLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NMarker;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NParameterRef
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.PARAMETER_REF;
    @CheckForNull
    public String localId;
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JParameterRef jRef = (JParameterRef)node;
        this.localId = loader.getVariableSymbols().getId(jRef.getParameter());
        this.sourceInfo = jRef.getSourceInfo();
        this.markers = loader.load(NMarker.class, jRef.getAllMarkers());
    }

    @Override
    @Nonnull
    public JParameterRef exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.localId != null);
        JParameterRef jRef = JParameterUnresolved.INSTANCE.makeRef(this.sourceInfo);
        exportSession.getVariableResolver().addLink(this.localId, new VariableRefLinker(jRef));
        for (NMarker marker : this.markers) {
            jRef.addMarker(marker.exportAsJast(exportSession));
        }
        return jRef;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.localId);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.localId = in.readId();
        this.markers = in.readNodes(NMarker.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipId();
        in.skipNodes();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

