/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NReturnStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.RETURN_STATEMENT;
    @CheckForNull
    public NExpression expr;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JReturnStatement jStatement = (JReturnStatement)node;
        this.expr = (NExpression)loader.load(jStatement.getExpr());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jStatement.getJCatchBlocks());
        this.sourceInfo = jStatement.getSourceInfo();
    }

    @Override
    @Nonnull
    public JReturnStatement exportAsJast(@Nonnull ExportSession exportSession) throws JMethodLookupException, JTypeLookupException {
        assert (this.sourceInfo != null);
        JExpression jExpr = this.expr != null ? this.expr.exportAsJast(exportSession) : null;
        JReturnStatement statement = new JReturnStatement(this.sourceInfo, jExpr);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(statement));
        }
        return statement;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.expr);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.expr = in.readNode(NExpression.class);
    }

    public static void skipContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        in.skipNode();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

