/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.kohsuke.args4j.spi;

import com.android.jack.kohsuke.args4j.CmdLineException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.OptionDef;
import com.android.jack.kohsuke.args4j.spi.Messages;
import com.android.jack.kohsuke.args4j.spi.OptionHandler;
import com.android.jack.kohsuke.args4j.spi.Parameters;
import com.android.jack.kohsuke.args4j.spi.Setter;
import java.util.Arrays;
import java.util.List;

public class BooleanOptionHandler
extends OptionHandler<Boolean> {
    private static final List<String> ACCEPTABLE_VALUES = Arrays.asList("true", "on", "yes", "1", "false", "off", "no", "0");

    public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        if (this.option.isArgument()) {
            String valueStr = params.getParameter(0).toLowerCase();
            int index = ACCEPTABLE_VALUES.indexOf(valueStr);
            if (index == -1) {
                throw new CmdLineException(this.owner, Messages.ILLEGAL_BOOLEAN, valueStr);
            }
            this.setter.addValue(index < ACCEPTABLE_VALUES.size() / 2);
            return 1;
        }
        this.setter.addValue(true);
        return 0;
    }

    @Override
    public String getDefaultMetaVariable() {
        return null;
    }
}

