/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.library.JarLibrary;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.InputZipFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.file.ZipException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JarLibraryCodec
extends FileOrDirCodec<JarLibrary> {
    public JarLibraryCodec() {
        super(FileOrDirectory.Existence.MUST_EXIST, 1);
    }

    @Override
    @Nonnull
    public JarLibrary parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public JarLibrary checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        InputZipFile inputZipFile;
        try {
            inputZipFile = new InputZipFile(context.getWorkingDirectory(), string);
        }
        catch (NotFileException e) {
            throw new ParsingException(e.getMessage(), e);
        }
        catch (NoSuchFileException e) {
            throw new ParsingException(e.getMessage(), e);
        }
        catch (WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
        catch (ZipException e) {
            throw new ParsingException(e.getMessage(), e);
        }
        return new JarLibrary(inputZipFile);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a jar file (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "jar";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull JarLibrary data) {
        return data.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull JarLibrary data) {
    }
}

