/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.lookup;

import com.android.jack.Jack;
import com.android.jack.ir.ast.IncompatibleJTypeLookupException;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPackageLookupException;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.lookup.JLookup;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.PercentImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class JNodeLookup
extends JLookup {
    @Nonnull
    public static final StatisticId<Percent> SUCCESS_LOOKUP = new StatisticId<Percent>("jack.lookup.success", "Lookup requests returning a JDefinedClassOrInterface", PercentImpl.class, Percent.class);
    @Nonnull
    private final Map<String, JType> types = new HashMap<String, JType>();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final JLookup.Adapter<JType> adapter = new JLookup.Adapter<JType>(){

        @Override
        @Nonnull
        public Map<String, JType> getCache() {
            return JNodeLookup.this.types;
        }

        @Override
        @Nonnull
        public JType getType(@Nonnull JPackage pack, @Nonnull String simpleName) throws JTypeLookupException {
            return pack.getType(simpleName);
        }

        @Override
        @Nonnull
        public JPackage getPackage(@Nonnull JPackage pack, @Nonnull String simpleName) throws JPackageLookupException {
            return pack.getSubPackage(simpleName);
        }
    };

    public JNodeLookup(@Nonnull JPackage topLevelPackage) {
        super(topLevelPackage);
        this.init();
    }

    @Nonnull
    public JPackage getTopLevelPackage() {
        return this.topLevelPackage;
    }

    public boolean isPackageOnPath(@Nonnull String packageName) {
        try {
            return this.getPackage(packageName, this.adapter).isOnPath();
        }
        catch (JPackageLookupException e) {
            return false;
        }
    }

    @Override
    @Nonnull
    public JType getType(@Nonnull String typeSignature) throws JTypeLookupException {
        Percent statistic = this.tracer.getStatistic(SUCCESS_LOOKUP);
        statistic.addFalse();
        JType result = this.getType(typeSignature, this.adapter);
        statistic.removeFalse();
        statistic.addTrue();
        return result;
    }

    @Override
    @Nonnull
    public JDefinedClass getClass(@Nonnull String typeSignature) throws JTypeLookupException {
        JType type = this.getType(typeSignature);
        if (type instanceof JDefinedClass) {
            return (JDefinedClass)type;
        }
        throw new IncompatibleJTypeLookupException(type, JDefinedEnum.class);
    }

    @Override
    @Nonnull
    public JDefinedInterface getInterface(@Nonnull String typeSignature) throws JTypeLookupException {
        JType type = this.getType(typeSignature);
        if (type instanceof JDefinedInterface) {
            return (JDefinedInterface)type;
        }
        throw new IncompatibleJTypeLookupException(type, JDefinedInterface.class);
    }

    private void addType(@Nonnull JType type) {
        this.types.put(Jack.getLookupFormatter().getName(type), type);
    }

    @Override
    @Nonnull
    public JDefinedAnnotationType getAnnotationType(@Nonnull String signature) throws JTypeLookupException {
        JType type = this.getType(signature);
        if (type instanceof JDefinedAnnotationType) {
            return (JDefinedAnnotationType)type;
        }
        throw new IncompatibleJTypeLookupException(type, JDefinedAnnotationType.class);
    }

    @Override
    @Nonnull
    public JDefinedEnum getEnum(@Nonnull String typeSignature) throws JTypeLookupException {
        JType type = this.getType(typeSignature);
        if (type instanceof JDefinedEnum) {
            return (JDefinedEnum)type;
        }
        throw new IncompatibleJTypeLookupException(type, JDefinedEnum.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Map<String, JType> map = this.types;
        synchronized (map) {
            this.types.clear();
            this.init();
        }
    }

    @Override
    public void removeType(@Nonnull JType type) {
        this.clear();
    }

    private void init() {
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType());
        this.addType(JPrimitiveType.JPrimitiveTypeEnum.LONG.getType());
        this.addType(JNullType.INSTANCE);
    }
}

