/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.lookup;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MissingJTypeLookupException;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JLookupException;
import com.android.jack.lookup.JNodeLookup;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JPhantomLookup
extends JLookup {
    @Nonnull
    private final Map<String, JReferenceType> typeCache = new HashMap<String, JReferenceType>();
    @Nonnull
    private final Map<String, JClass> classCache = new HashMap<String, JClass>();
    @Nonnull
    private final Map<String, JEnum> enumCache = new HashMap<String, JEnum>();
    @Nonnull
    private final Map<String, JInterface> interfaceCache = new HashMap<String, JInterface>();
    @Nonnull
    private final Map<String, JAnnotationType> annotationCache = new HashMap<String, JAnnotationType>();
    @Nonnull
    private final PhantomAdapter<JReferenceType> coiAdapter = new PhantomAdapter<JReferenceType>(){

        @Override
        @Nonnull
        public Map<String, JReferenceType> getCache() {
            return JPhantomLookup.this.typeCache;
        }

        @Override
        @Nonnull
        public JReferenceType getType(@Nonnull JPackage pack, @Nonnull String simpleName) {
            return pack.getPhantomClassOrInterface(simpleName);
        }

        @Override
        @Nonnull
        public JReferenceType getDefined(@Nonnull String signature) {
            throw new UnsupportedOperationException();
        }
    };
    @Nonnull
    private final PhantomAdapter<JClass> classAdapter = new PhantomAdapter<JClass>(){

        @Override
        @Nonnull
        public Map<String, JClass> getCache() {
            return JPhantomLookup.this.classCache;
        }

        @Override
        @Nonnull
        public JClass getType(@Nonnull JPackage pack, @Nonnull String simpleName) {
            return pack.getPhantomClass(simpleName);
        }

        @Override
        @Nonnull
        public JClass getDefined(@Nonnull String signature) {
            return JPhantomLookup.this.jackLookup.getClass(signature);
        }
    };
    @Nonnull
    private final PhantomAdapter<JEnum> enumAdapter = new PhantomAdapter<JEnum>(){

        @Override
        @Nonnull
        public Map<String, JEnum> getCache() {
            return JPhantomLookup.this.enumCache;
        }

        @Override
        @Nonnull
        public JEnum getType(@Nonnull JPackage pack, @Nonnull String simpleName) {
            return pack.getPhantomEnum(simpleName);
        }

        @Override
        @Nonnull
        public JEnum getDefined(@Nonnull String signature) {
            return JPhantomLookup.this.jackLookup.getEnum(signature);
        }
    };
    @Nonnull
    private final PhantomAdapter<JInterface> interfaceAdapter = new PhantomAdapter<JInterface>(){

        @Override
        @Nonnull
        public Map<String, JInterface> getCache() {
            return JPhantomLookup.this.interfaceCache;
        }

        @Override
        @Nonnull
        public JInterface getType(@Nonnull JPackage pack, @Nonnull String simpleName) {
            return pack.getPhantomInterface(simpleName);
        }

        @Override
        @Nonnull
        public JInterface getDefined(@Nonnull String signature) {
            return JPhantomLookup.this.jackLookup.getInterface(signature);
        }
    };
    @Nonnull
    private final PhantomAdapter<JAnnotationType> annotationAdapter = new PhantomAdapter<JAnnotationType>(){

        @Override
        @Nonnull
        public Map<String, JAnnotationType> getCache() {
            return JPhantomLookup.this.annotationCache;
        }

        @Override
        @Nonnull
        public JAnnotationType getType(@Nonnull JPackage pack, @Nonnull String simpleName) {
            return pack.getPhantomAnnotationType(simpleName);
        }

        @Override
        @Nonnull
        public JAnnotationType getDefined(@Nonnull String signature) {
            return JPhantomLookup.this.jackLookup.getAnnotationType(signature);
        }
    };
    @Nonnull
    private final JNodeLookup jackLookup;

    public JPhantomLookup(@Nonnull JNodeLookup jackLookup) {
        super(jackLookup.getTopLevelPackage());
        this.jackLookup = jackLookup;
    }

    @Override
    @Nonnull
    public JType getType(@Nonnull String signature) {
        JType type;
        try {
            type = this.jackLookup.getType(signature);
            assert (!this.doesCacheContain(this.typeCache, signature));
        }
        catch (JLookupException e) {
            try {
                type = this.getType(signature, this.coiAdapter);
            }
            catch (MissingJTypeLookupException t) {
                throw new AssertionError((Object)signature);
            }
        }
        return type;
    }

    @Override
    protected <T extends JReferenceType> T getNonArrayType(@Nonnull String signature, @Nonnull JLookup.Adapter<T> adapter) {
        Object type;
        Map<String, T> cache = adapter.getCache();
        try {
            type = ((PhantomAdapter)adapter).getDefined(signature);
            assert (!this.doesCacheContain(cache, signature));
        }
        catch (JLookupException e) {
            try {
                type = super.getNonArrayType(signature, adapter);
            }
            catch (MissingJTypeLookupException t) {
                throw new AssertionError((Object)signature);
            }
        }
        return type;
    }

    @Override
    @Nonnull
    public JClass getClass(@Nonnull String signature) {
        return this.getNonArrayType(signature, this.classAdapter);
    }

    @Override
    @Nonnull
    public JInterface getInterface(@Nonnull String signature) {
        return this.getNonArrayType(signature, this.interfaceAdapter);
    }

    @Override
    @Nonnull
    public JAnnotationType getAnnotationType(@Nonnull String signature) {
        return this.getNonArrayType(signature, this.annotationAdapter);
    }

    @Override
    @Nonnull
    public JEnum getEnum(@Nonnull String signature) {
        return this.getNonArrayType(signature, this.enumAdapter);
    }

    @Override
    @Nonnull
    public JClass getClass(@Nonnull CommonTypes.CommonType type) {
        try {
            return super.getClass(type);
        }
        catch (JTypeLookupException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nonnull
    public JInterface getInterface(@Nonnull CommonTypes.CommonType type) {
        try {
            return super.getInterface(type);
        }
        catch (JTypeLookupException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nonnull
    public JType getType(@Nonnull CommonTypes.CommonType type) {
        try {
            return super.getType(type);
        }
        catch (JTypeLookupException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Map<String, JReferenceType> map = this.typeCache;
        synchronized (map) {
            this.typeCache.clear();
        }
        map = this.classCache;
        synchronized (map) {
            this.classCache.clear();
        }
        map = this.enumCache;
        synchronized (map) {
            this.enumCache.clear();
        }
        map = this.interfaceCache;
        synchronized (map) {
            this.interfaceCache.clear();
        }
        map = this.annotationCache;
        synchronized (map) {
            this.annotationCache.clear();
        }
    }

    @Override
    public void removeType(@Nonnull JType type) {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesCacheContain(@Nonnull Map<String, ? extends JReferenceType> cache, @Nonnull String signature) {
        Map<String, ? extends JReferenceType> map = cache;
        synchronized (map) {
            return cache.containsKey(signature);
        }
    }

    public boolean check(@Nonnull JType checkedType) {
        JType defined;
        String signature = Jack.getLookupFormatter().getName(checkedType);
        try {
            defined = this.jackLookup.getType(signature);
            if (!defined.isSameType(checkedType)) {
                throw JPhantomLookup.getCheckError(checkedType, defined);
            }
        }
        catch (JLookupException e) {
            defined = null;
        }
        this.checkCacheContent(checkedType, signature, defined, JType.class, this.typeCache);
        this.checkCacheContent(checkedType, signature, defined, JClass.class, this.classCache);
        this.checkCacheContent(checkedType, signature, defined, JEnum.class, this.enumCache);
        this.checkCacheContent(checkedType, signature, defined, JInterface.class, this.interfaceCache);
        this.checkCacheContent(checkedType, signature, defined, JAnnotationType.class, this.annotationCache);
        return true;
    }

    private void checkCacheContent(@Nonnull JType checkedType, @Nonnull String signature, @CheckForNull JType defined, @Nonnull Class<?> clazz, @Nonnull Map<String, ? extends JType> cache) {
        JType phantom;
        if (!clazz.isInstance(defined) && (phantom = cache.get(signature)) != null && !phantom.isSameType(checkedType)) {
            throw JPhantomLookup.getCheckError(checkedType, phantom);
        }
    }

    @Nonnull
    private static AssertionError getCheckError(@Nonnull JType checkedType, @Nonnull JType ref) {
        TypePackageAndMethodFormatter formatter = Jack.getLookupFormatter();
        return new AssertionError((Object)(formatter.getName(checkedType) + " (" + checkedType.getClass().getName() + ") does not equal with " + formatter.getName(ref) + " (" + ref.getClass().getName() + ")"));
    }

    @Override
    @Nonnull
    protected JArrayType findArrayType(@Nonnull String typeName) {
        try {
            return super.findArrayType(typeName);
        }
        catch (JTypeLookupException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static abstract class PhantomAdapter<T extends JReferenceType>
    implements JLookup.Adapter<T> {
        private PhantomAdapter() {
        }

        @Override
        @Nonnull
        public JPackage getPackage(@Nonnull JPackage pack, @Nonnull String simpleName) {
            return pack.getOrCreateSubPackage(simpleName);
        }

        @Nonnull
        public abstract T getDefined(@Nonnull String var1);
    }
}

