/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.meta;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.FileType;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryWritingException;
import com.android.jack.library.MetaInInputLibraryLocation;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.meta.Meta;
import com.android.jack.reporting.Reporter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.ZipLocation;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Writes metas in libraries")
public class LibraryMetaWriter
implements RunnableSchedulable<JSession> {
    @Override
    public void run(@Nonnull JSession session) {
        OutputJackLibrary ojl = session.getJackOutputLibrary();
        try {
            List<Meta> metas = session.getMetas();
            for (Meta meta : metas) {
                this.addMetaToOutputJackLib(meta, ojl);
            }
            for (InputLibrary importedLibrary : session.getImportedLibraries()) {
                if (!importedLibrary.containsFileType(FileType.META)) continue;
                Iterator<InputVFile> metaIter = importedLibrary.iterator(FileType.META);
                while (metaIter.hasNext()) {
                    InputVFile metaFile = metaIter.next();
                    if (metaFile.getName().endsWith(".dep")) continue;
                    VPath path = this.getNameFromInputVFile(importedLibrary, metaFile);
                    Meta meta = new Meta(path, metaFile, new MetaInInputLibraryLocation(importedLibrary, path));
                    this.addMetaToOutputJackLib(meta, ojl);
                }
            }
        }
        catch (CannotCloseException | CannotCreateFileException | CannotReadException | CannotWriteException | WrongPermissionException e) {
            LibraryWritingException reportable = new LibraryWritingException(new LibraryIOException(ojl.getLocation(), e));
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
            throw new JackAbortException(reportable);
        }
    }

    @Nonnull
    private VPath getNameFromInputVFile(@Nonnull InputLibrary jackLibrary, @Nonnull InputVFile metaFile) {
        VPath path;
        if (jackLibrary.getMajorVersion() == 0) {
            String name = ((ZipLocation)metaFile.getLocation()).getEntryName();
            name = name.substring("JACK-INF/".length());
            path = new VPath(name, '/');
        } else {
            path = metaFile.getPathFromRoot();
        }
        return path;
    }

    private void addMetaToOutputJackLib(@Nonnull Meta meta, @Nonnull OutputJackLibrary ojl) throws CannotCreateFileException, WrongPermissionException, CannotCloseException, CannotReadException, CannotWriteException {
        InputVFile inputFile = meta.getVFile();
        VPath path = meta.getPath();
        OutputVFile outputFile = ojl.createFile(FileType.META, path);
        outputFile.copy(inputFile);
    }
}

