/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.inlining;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.library.FileType;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.location.Location;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Performs check @ForceInline annotations")
@Constraint(no={DefinitionMarker.class, UseDefsMarker.class})
public class InlineAnnotationSanityCheck
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @CheckForNull
    private final JDefinedAnnotationType forceInlineAnnotationType = InlineAnnotationSanityCheck.getJAnnotationType("com.android.jack.annotations.ForceInline");

    private static void reportCycle() {
        Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new ForceInlineCycle());
        Jack.getSession().abortEventually();
    }

    @CheckForNull
    private static JDefinedAnnotationType getJAnnotationType(@Nonnull String className) {
        String signature = NamingTools.getTypeSignatureName(className);
        JAnnotationType type = Jack.getSession().getPhantomLookup().getAnnotationType(signature);
        if (type instanceof JDefinedAnnotationType) {
            return (JDefinedAnnotationType)type;
        }
        return null;
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (this.forceInlineAnnotationType == null) {
            return;
        }
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        HashSet<JMethod> inlineChain = new HashSet<JMethod>();
        inlineChain.add(method);
        new Checker(inlineChain).accept(method);
    }

    private static class ForceInlineCycle
    implements Reportable {
        private ForceInlineCycle() {
        }

        @Override
        public String getMessage() {
            return "Cannot perform annotated method inlining due to cycle detected in @ForceInline methods";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }

    private class Checker
    extends JVisitor {
        private final Set<JMethod> inlineChain;

        private Checker(Set<JMethod> inlineChain) {
            this.inlineChain = inlineChain;
        }

        @Override
        public void endVisit(@Nonnull JMethodCall call) {
            InputLibrary inputLibrary;
            Collection<JMethod> targets = call.getMethodIdWide().getMethods();
            if (targets.size() != 1) {
                return;
            }
            JMethod target = targets.iterator().next();
            if (target.isAbstract() || target.isNative()) {
                return;
            }
            Location location = target.getEnclosingType().getLocation();
            if (location instanceof TypeInInputLibraryLocation && (inputLibrary = ((TypeInInputLibraryLocation)location).getInputLibrary()).containsFileType(FileType.PREBUILT)) {
                return;
            }
            assert (InlineAnnotationSanityCheck.this.forceInlineAnnotationType != null);
            Collection annotationList = target.getAnnotations(InlineAnnotationSanityCheck.this.forceInlineAnnotationType);
            if (!annotationList.isEmpty()) {
                if (this.inlineChain.contains(target)) {
                    InlineAnnotationSanityCheck.reportCycle();
                } else {
                    this.inlineChain.add(target);
                    new Checker(this.inlineChain).accept(target);
                    this.inlineChain.remove(target);
                }
            }
        }
    }
}

