/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.inlining;

import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.google.common.collect.Maps;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.inlining.InlineCloneStatementVisitor;
import com.android.jack.optimizations.inlining.InlineMarker;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.AddJLocalInMethodBody;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.ControlFlowHelper;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Performs method inlining")
@Constraint(need={InlineMarker.class, ThreeAddressCodeForm.class}, no={UseDefsMarker.class})
@Transform(remove={InlineMarker.class}, add={JLocal.class, JLocalRef.class, JAsgOperation.NonReusedAsg.class, JExpressionStatement.class, JLabeledStatement.class})
@Use(value={InlineCloneStatementVisitor.class})
@Support(value={Optimizations.InlineAnnotatedMethods.class})
@ExclusiveAccess(value=JSession.class)
@Synchronized
public class JMethodInliner
implements RunnableSchedulable<JMethod> {
    private static void inline(@Nonnull JMethod callSiteMethod, @Nonnull JMethodCall callSite, @Nonnull JMethod target, @Nonnull TransformationRequest tr, @Nonnull LocalVarCreator lvc) {
        CandidateInfo candidate = new CandidateInfo(callSiteMethod, callSite, target);
        PrologueInfo prologue = new PrologueInfo(candidate);
        EpilogueInfo epilogue = new EpilogueInfo(candidate);
        JMethodInliner.prepareEpilogue(candidate, epilogue, tr);
        JMethodInliner.preparePrologue(candidate, prologue, tr, lvc);
        JMethodInliner.inlineBody(candidate, prologue, epilogue, tr);
    }

    private static void preparePrologue(@Nonnull CandidateInfo candidate, @Nonnull PrologueInfo prologue, @Nonnull TransformationRequest tr, @Nonnull LocalVarCreator lvc) {
        SourceInfo src = candidate.callSite.getSourceInfo();
        List<JParameter> params = candidate.target.getParams();
        for (int i = 0; i < candidate.callSite.getArgs().size(); ++i) {
            JExpression arg = candidate.callSite.getArgs().get(i);
            JLocal local = lvc.createTempLocal(params.get(i).getType(), src, tr);
            prologue.parameterMap.put(params.get(i), local);
            JMethodBody enclosingBody = candidate.callSiteMethodBody;
            assert (enclosingBody != null);
            tr.append(new AddJLocalInMethodBody(local, enclosingBody));
            tr.append(new AppendBefore(candidate.callSiteStmt, new JExpressionStatement(src, new JAsgOperation(src, local.makeRef(src), arg))));
        }
    }

    private static void inlineBody(@Nonnull CandidateInfo candidate, @Nonnull PrologueInfo prologue, @Nonnull EpilogueInfo epilogue, @Nonnull TransformationRequest tr) {
        JMethodBody body = (JMethodBody)candidate.target.getBody();
        JLabeledStatement returnLabel = epilogue.returnLabel;
        assert (returnLabel != null);
        assert (body != null);
        InlineCloneStatementVisitor cloner = new InlineCloneStatementVisitor(tr, candidate.callSiteMethod, candidate.callSiteStmt.getJCatchBlocks(), epilogue.returnLocal, returnLabel, prologue.targetThis, prologue.parameterMap);
        JBlock newBlock = cloner.cloneMethodBody(body);
        tr.append(new Replace(candidate.callSiteStmt, newBlock));
    }

    private static void prepareEpilogue(@Nonnull CandidateInfo candidate, @Nonnull EpilogueInfo epilogue, @Nonnull TransformationRequest tr) {
        SourceInfo src = candidate.callSite.getSourceInfo();
        JStatement next = ControlFlowHelper.getNextStatement(candidate.callSiteStmt);
        assert (next != null);
        JBlock nextBlock = new JBlock(src);
        nextBlock.addStmt(next);
        epilogue.returnLabel = new JLabeledStatement(src, new JLabel(src, ".inline_return_label"), nextBlock);
        tr.append(new Replace(next, epilogue.returnLabel));
    }

    @Override
    public void run(JMethod jm) {
        if (jm.isNative() || jm.isAbstract()) {
            return;
        }
        Visitor v = null;
        do {
            TransformationRequest tr = new TransformationRequest(jm);
            v = new Visitor(jm, tr);
            v.accept(jm);
            tr.commit();
        } while (v.inlined);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod enclosingMethod;
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final LocalVarCreator lvc;
        private boolean inlined = false;

        private Visitor(@Nonnull JMethod enclosingMethod, @Nonnull TransformationRequest tr) {
            this.enclosingMethod = enclosingMethod;
            this.tr = tr;
            this.lvc = new LocalVarCreator(enclosingMethod, ".inline_tmp");
        }

        @Override
        public void endVisit(@Nonnull JMethodCall jmc) {
            InlineMarker marker = jmc.removeMarker(InlineMarker.class);
            if (marker == null) {
                return;
            }
            assert (this.enclosingMethod != null);
            assert (this.lvc != null);
            assert (this.enclosingMethod != marker.getTarget());
            JMethodInliner.inline(this.enclosingMethod, jmc, marker.getTarget(), this.tr, this.lvc);
            this.inlined = true;
        }
    }

    private static class EpilogueInfo {
        @CheckForNull
        private final JLocal returnLocal;
        @CheckForNull
        private JLabeledStatement returnLabel = null;

        private EpilogueInfo(@Nonnull CandidateInfo candidate) {
            if (candidate.callSiteStmt.getExpr() instanceof JAsgOperation) {
                JAsgOperation assign = (JAsgOperation)candidate.callSiteStmt.getExpr();
                this.returnLocal = ((JLocalRef)assign.getLhs()).getLocal();
            } else {
                this.returnLocal = null;
            }
        }
    }

    private static class PrologueInfo {
        @Nonnull
        private final Map<JParameter, JLocal> parameterMap = Maps.newHashMap();
        @CheckForNull
        private final JVariable targetThis;

        private PrologueInfo(@Nonnull CandidateInfo candidate) {
            JExpression instance = candidate.callSite.getInstance();
            this.targetThis = instance == null ? null : ((JVariableRef)instance).getTarget();
        }
    }

    private static class CandidateInfo {
        @Nonnull
        private final JMethod callSiteMethod;
        @Nonnull
        private final JMethodBody callSiteMethodBody;
        @Nonnull
        private final JMethodCall callSite;
        @Nonnull
        private final JExpressionStatement callSiteStmt;
        @Nonnull
        private final JMethod target;

        private CandidateInfo(@Nonnull JMethod callSiteMethod, @Nonnull JMethodCall callSite, @Nonnull JMethod target) {
            this.callSiteMethod = callSiteMethod;
            JAbstractMethodBody callSiteMethodBody = callSiteMethod.getBody();
            assert (callSiteMethodBody != null);
            this.callSiteMethodBody = (JMethodBody)callSiteMethodBody;
            this.callSiteStmt = callSite.getParent(JExpressionStatement.class);
            this.callSite = callSite;
            this.target = target;
        }
    }
}

