/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.tailrecursion;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.annotations.DisableTailRecursionOptimization;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.request.AddJLocalInMethodBody;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.PrependStatement;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Optimizes tail recursive calls")
@Constraint(need={JReturnStatement.class, JMethodCall.class}, no={ThreeAddressCodeForm.class})
@Transform(add={JLabeledStatement.class, JLabel.class, JBlock.class, JLocal.class, JAsgOperation.class, JLocalRef.class, JParameterRef.class, JExpressionStatement.class, JGoto.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class TailRecursionOptimizer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private static final StatisticId<Counter> TAIL_RECURSION_OPTS = new StatisticId<Counter>("jack.optimization.tail-recursion", "Tail recursion optimizations", CounterImpl.class, Counter.class);
    @Nonnull
    private final JAnnotationType annotationType = Jack.getSession().getPhantomLookup().getAnnotationType(NamingTools.getTypeSignatureName(DisableTailRecursionOptimization.class.getName()));

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !method.isFinal() && !method.isPrivate() && !method.isStatic() || method.isSynthetic() || !this.filter.accept(this.getClass(), method) || !method.getAnnotations(this.annotationType).isEmpty() || !method.getEnclosingType().getAnnotations(this.annotationType).isEmpty()) {
            return;
        }
        TransformationRequest request = new TransformationRequest(method);
        TailRecursionVisitor visitor = new TailRecursionVisitor(method, request);
        visitor.accept(method);
        request.commit();
    }

    private class TailRecursionVisitor
    extends JVisitor {
        @Nonnull
        private final JMethod enclosingMethod;
        @Nonnull
        private final TransformationRequest tr;
        @CheckForNull
        private JLabeledStatement labeledFirstStatement = null;

        private TailRecursionVisitor(@Nonnull JMethod method, TransformationRequest tr) {
            this.enclosingMethod = method;
            this.tr = tr;
        }

        private void labelFirstStatement() {
            JMethodBody body = (JMethodBody)this.enclosingMethod.getBody();
            assert (body != null);
            JBlock block = body.getBlock();
            JStatement firstStatement = block.getStatements().get(0);
            assert (firstStatement != null);
            if (firstStatement instanceof JLabeledStatement) {
                this.labeledFirstStatement = (JLabeledStatement)firstStatement;
            } else {
                SourceInfo srcInfo = firstStatement.getSourceInfo();
                this.labeledFirstStatement = new JLabeledStatement(srcInfo, new JLabel(srcInfo, "method.start"), new JBlock(srcInfo));
                this.tr.append(new PrependStatement(block, this.labeledFirstStatement));
            }
        }

        @Override
        public boolean visit(@Nonnull JTryStatement tryStatement) {
            return false;
        }

        @Override
        public boolean visit(@Nonnull JReturnStatement returnStatement) {
            JExpression retExpr = returnStatement.getExpr();
            if (retExpr instanceof JMethodCall) {
                JMethodCall methodCall = (JMethodCall)retExpr;
                JExpression instance = methodCall.getInstance();
                if (methodCall.getMethodIdWide().equals(this.enclosingMethod.getMethodIdWide()) && (instance == null || instance.getType().isSameType(methodCall.getReceiverType()) && instance instanceof JThisRef)) {
                    ((Counter)TailRecursionOptimizer.this.tracer.getStatistic(TAIL_RECURSION_OPTS)).incValue();
                    if (this.labeledFirstStatement == null) {
                        this.labelFirstStatement();
                    }
                    assert (this.labeledFirstStatement != null);
                    SourceInfo srcInfo = returnStatement.getSourceInfo();
                    JMethodBody body = (JMethodBody)this.enclosingMethod.getBody();
                    assert (body != null);
                    Iterator<JParameter> paramIt = this.enclosingMethod.getParams().iterator();
                    Iterator<JExpression> exprIt = methodCall.getArgs().iterator();
                    ArrayList<JExpressionStatement> tmpAssignments = new ArrayList<JExpressionStatement>();
                    ArrayList<JExpressionStatement> argAssignments = new ArrayList<JExpressionStatement>();
                    while (paramIt.hasNext() && exprIt.hasNext()) {
                        JParameter param = paramIt.next();
                        Iterator expr = exprIt.next();
                        JLocal jLocal = new JLocal(srcInfo, "tmp." + param.getName(), param.getType(), 16, body);
                        this.tr.append(new AddJLocalInMethodBody(jLocal, body));
                        JAsgOperation asgToTemp = new JAsgOperation(srcInfo, jLocal.makeRef(srcInfo), (JExpression)((Object)expr));
                        JExpressionStatement asgToTempStmt = new JExpressionStatement(srcInfo, asgToTemp);
                        tmpAssignments.add(asgToTempStmt);
                        JAsgOperation tempToArg = new JAsgOperation(srcInfo, param.makeRef(srcInfo), jLocal.makeRef(srcInfo));
                        JExpressionStatement tempToArgStmt = new JExpressionStatement(srcInfo, tempToArg);
                        argAssignments.add(tempToArgStmt);
                    }
                    JStatementList returnStmtParent = (JStatementList)returnStatement.getParent();
                    assert (returnStmtParent != null);
                    for (JStatement jStatement : tmpAssignments) {
                        this.tr.append(new AppendStatement(returnStmtParent, jStatement));
                    }
                    for (JStatement jStatement : argAssignments) {
                        this.tr.append(new AppendStatement(returnStmtParent, jStatement));
                    }
                    JGoto tailCall = new JGoto(returnStatement.getSourceInfo(), this.labeledFirstStatement);
                    tailCall.setCatchBlocks(returnStatement.getJCatchBlocks());
                    this.tr.append(new AppendStatement(returnStmtParent, tailCall));
                    this.tr.append(new Remove(returnStatement));
                }
            }
            return false;
        }
    }
}

