/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.optimizations.valuepropagation.argument.AvpSchedulable;
import com.android.jack.optimizations.valuepropagation.argument.TaintedVirtualMethodsMarker;
import com.android.jack.optimizations.valuepropagation.argument.TypeMethodCallArgumentsMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Argument value propagation, collecting method call argument values")
@Constraint(need={ControlFlowGraph.class, JMethodCall.class})
@Transform(add={TaintedVirtualMethodsMarker.class, TypeMethodCallArgumentsMarker.class})
@Name(value="ArgumentValuePropagation: CollectMethodCallArguments")
public class AvpCollectMethodCallArguments
extends AvpSchedulable
implements RunnableSchedulable<JMethod> {
    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isAbstract() || method.isNative()) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                JMethodCall call;
                JMethodIdWide methodId;
                if (!(stmt instanceof JExpressionStatement)) continue;
                JExpression expr = ((JExpressionStatement)stmt).getExpr();
                if (expr instanceof JAsgOperation) {
                    expr = ((JAsgOperation)expr).getRhs();
                }
                if (!(expr instanceof JMethodCall) || (methodId = (call = (JMethodCall)expr).getMethodIdWide()).getParamTypes().size() <= 0) continue;
                TypeMethodCallArgumentsMarker.markCallOnReceiverType(this.getMethodSignature(methodId, call.getType()), call);
            }
        }
    }
}

