/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.optimizations.common.ConcurrentLiteralValueListTracker;
import com.android.jack.optimizations.common.LiteralValueListTracker;
import com.android.jack.optimizations.valuepropagation.argument.TaintedVirtualMethodsMarker;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Represents argument trackers for all the methods called on the type.")
@ValidOn(value={JDefinedClassOrInterface.class})
public class TypeMethodCallArgumentsMarker
implements Marker {
    @Nonnull
    private final ConcurrentMap<String, LiteralValueListTracker> virtual = new ConcurrentHashMap<String, LiteralValueListTracker>();
    @Nonnull
    private final ConcurrentMap<String, LiteralValueListTracker> direct = new ConcurrentHashMap<String, LiteralValueListTracker>();

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    private void markCall(@Nonnull String signature, @Nonnull List<JExpression> args, @Nonnull JMethodCall.DispatchKind dispatchKind) {
        LiteralValueListTracker existing;
        ConcurrentMap<String, LiteralValueListTracker> map = dispatchKind == JMethodCall.DispatchKind.VIRTUAL ? this.virtual : this.direct;
        LiteralValueListTracker tracker = (LiteralValueListTracker)map.get(signature);
        if (tracker == null && (existing = map.putIfAbsent(signature, tracker = new ConcurrentLiteralValueListTracker(args.size()))) != null) {
            tracker = existing;
        }
        tracker.updateWith(args);
    }

    @CheckForNull
    public static ConcurrentMap<String, LiteralValueListTracker> getCallsArgsOnType(@Nonnull JDefinedClassOrInterface type, boolean isVirtual) {
        TypeMethodCallArgumentsMarker marker = type.getMarker(TypeMethodCallArgumentsMarker.class);
        return marker == null ? null : (isVirtual ? marker.virtual : marker.direct);
    }

    public static void markCallOnReceiverType(@Nonnull String signature, @Nonnull JMethodCall call) {
        TypeMethodCallArgumentsMarker existing;
        List<JExpression> args = call.getArgs();
        assert (!args.isEmpty());
        JClassOrInterface receiverType = call.getReceiverType();
        if (!receiverType.isToEmit()) {
            return;
        }
        assert (receiverType instanceof JDefinedClassOrInterface);
        JDefinedClassOrInterface type = (JDefinedClassOrInterface)receiverType;
        TaintedVirtualMethodsMarker taintedMarker = TaintedVirtualMethodsMarker.getMarker(type);
        if (call.getMethodIdWide().getKind() == MethodKind.INSTANCE_VIRTUAL && taintedMarker != null && taintedMarker.isMethodTainted(signature)) {
            return;
        }
        TypeMethodCallArgumentsMarker marker = type.getMarker(TypeMethodCallArgumentsMarker.class);
        if (marker == null && (existing = type.addMarkerIfAbsent(marker = new TypeMethodCallArgumentsMarker())) != null) {
            marker = existing;
        }
        marker.markCall(signature, args, call.getDispatchKind());
    }
}

