/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.field;

import com.android.jack.Jack;
import com.android.jack.annotations.DisableFieldValuePropagationOptimization;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.common.ExpressionReplaceHelper;
import com.android.jack.optimizations.common.JlsNullabilityChecker;
import com.android.jack.optimizations.common.OptimizerUtils;
import com.android.jack.optimizations.valuepropagation.field.FieldSingleValueMarker;
import com.android.jack.optimizations.valuepropagation.field.FvpSchedulable;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Field value propagation, field reads substitution")
@Constraint(need={FieldSingleValueMarker.class, ThreeAddressCodeForm.class})
@Transform(add={JValueLiteral.class})
@Use(value={ExpressionReplaceHelper.class, JlsNullabilityChecker.class})
@Name(value="FieldValuePropagation: PropagateFieldValues")
public class FvpPropagateFieldValues
extends FvpSchedulable
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public final JAnnotationType disablingAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType(NamingTools.getTypeSignatureName(DisableFieldValuePropagationOptimization.class.getName()));
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final JPhantomLookup phantomLookup = Jack.getSession().getPhantomLookup();
    private final boolean preserveNullChecks = ThreadConfig.get(Optimizations.FieldValuePropagation.PRESERVE_NULL_CHECKS);
    private final boolean ensureTypeInitializers = ThreadConfig.get(Optimizations.FieldValuePropagation.ENSURE_TYPE_INITIALIZERS);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract()) {
            return;
        }
        Visitor visitor = new Visitor(method, this.preserveNullChecks);
        visitor.accept(method);
        visitor.request.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;
        private final boolean insideConstructor;
        @CheckForNull
        private final JlsNullabilityChecker jlsNullabilityHelper;
        @Nonnull
        private final ExpressionReplaceHelper replaceHelper;
        @Nonnull
        public final TransformationRequest request;

        Visitor(JMethod method, boolean addNullChecks) {
            this.method = method;
            this.insideConstructor = OptimizerUtils.isConstructor(method);
            this.request = new TransformationRequest(method);
            LocalVarCreator fvp = new LocalVarCreator(method, "fvp");
            this.replaceHelper = new ExpressionReplaceHelper(fvp);
            this.jlsNullabilityHelper = addNullChecks ? new JlsNullabilityChecker(fvp, FvpPropagateFieldValues.this.phantomLookup) : null;
        }

        @Override
        public void endVisit(@Nonnull JFieldRef ref) {
            this.replaceFieldWithValue(ref);
            super.endVisit(ref);
        }

        private void replaceFieldWithValue(@Nonnull JFieldRef ref) {
            if (OptimizerUtils.isAssigned(ref)) {
                return;
            }
            JField field = ref.getFieldId().getField();
            if (field == null || !field.getAnnotations(FvpPropagateFieldValues.this.disablingAnnotationType).isEmpty() || !field.getEnclosingType().getAnnotations(FvpPropagateFieldValues.this.disablingAnnotationType).isEmpty()) {
                return;
            }
            JDefinedClassOrInterface type = field.getEnclosingType();
            if (!type.isToEmit()) {
                return;
            }
            FieldSingleValueMarker marker = FieldSingleValueMarker.getOrCreate(field);
            if (marker == null || marker.isMultipleOrNonLiteralValue()) {
                return;
            }
            if (this.insideConstructor && type == this.method.getEnclosingType() && this.method.isStatic() == field.isStatic() && (this.method.isStatic() || ref.getInstance() instanceof JThisRef)) {
                return;
            }
            if (field.isStatic() && FvpPropagateFieldValues.this.ensureTypeInitializers && field.getEnclosingType() != this.method.getEnclosingType()) {
                return;
            }
            JValueLiteral value = marker.getConsolidatedValue();
            if (value == null) {
                value = FvpSchedulable.createDefaultValue(field);
            } else {
                value = OptimizerUtils.cloneExpression(value);
                value.setSourceInfo(ref.getSourceInfo());
            }
            this.replaceHelper.replace(ref, value, this.request);
            FvpPropagateFieldValues.this.tracer.getStatistic(FvpSchedulable.FIELD_VALUES_PROPAGATED).incValue();
            if (this.jlsNullabilityHelper != null && !field.isStatic()) {
                JExpression instance = ref.getInstance();
                assert (instance != null);
                JStatement nullCheck = this.jlsNullabilityHelper.createNullCheckIfNeeded(instance, this.request);
                if (nullCheck != null) {
                    JStatement stmt = instance.getParent(JStatement.class);
                    this.request.append(new AppendBefore(stmt, nullCheck));
                }
            }
        }
    }
}

