/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.preprocessor;

import com.android.jack.Jack;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.preprocessor.PreProcessorApplier;
import com.android.jack.preprocessor.Rule;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public class AddAnnotationStep {
    @Nonnull
    private final Rule rule;
    @Nonnull
    private final JAnnotationType annotationType;
    @Nonnull
    private final Collection<?> toAnnotate;

    public AddAnnotationStep(@Nonnull Rule rule, @Nonnull JAnnotationType annotation, @Nonnull Collection<?> toAnnotate) {
        this.rule = rule;
        this.annotationType = annotation;
        this.toAnnotate = toAnnotate;
    }

    public void apply(@Nonnull Map<PreProcessorApplier.Entry, Rule> map) {
        for (Object candidate : this.toAnnotate) {
            Reportable reportable;
            if (!(candidate instanceof Annotable)) continue;
            Annotable annotable = (Annotable)candidate;
            PreProcessorApplier.Entry entry = new PreProcessorApplier.Entry(annotable, this.annotationType);
            if (annotable.getAnnotations(this.annotationType).isEmpty()) {
                JRetentionPolicy retention = JRetentionPolicy.SOURCE;
                if (this.annotationType instanceof JDefinedAnnotationType) {
                    retention = ((JDefinedAnnotationType)this.annotationType).getRetentionPolicy();
                }
                JAnnotation annotation = new JAnnotation(SourceInfo.UNKNOWN, retention, this.annotationType);
                annotable.addAnnotation(annotation);
                annotation.updateParents((JNode)((Object)annotable));
                map.put(entry, this.rule);
                reportable = new AnnotateReportable(annotable);
            } else {
                Rule rule = map.get(entry);
                reportable = rule == null ? new AlreadySourceAnnotateReportable(annotable) : new AlreadyRuleAnnotateReportable(annotable, rule);
            }
            Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, reportable);
        }
    }

    @Nonnull
    public static String getElement(@Nonnull TypePackageAndMethodFormatter formatter, @Nonnull Annotable annotable) {
        String element = "";
        if (annotable instanceof JType) {
            element = "type '" + formatter.getName((JType)((Object)annotable)) + "'";
        } else if (annotable instanceof JField) {
            JField field = (JField)annotable;
            element = "field '" + formatter.getName(field.getEnclosingType()) + "." + field.getName() + "'";
        } else if (annotable instanceof JMethod) {
            JMethod method = (JMethod)annotable;
            element = "method '" + formatter.getName(method.getEnclosingType()) + "." + formatter.getNameWithoutReturnType(method.getMethodIdWide()) + "'";
        } else if (annotable instanceof JPackage) {
            element = "package '" + formatter.getName((JPackage)((Object)annotable)) + "'";
        } else {
            throw new AssertionError((Object)annotable.getClass().getCanonicalName());
        }
        return element;
    }

    private final class AlreadyRuleAnnotateReportable
    implements Reportable {
        @Nonnull
        private final Annotable annotated;
        @Nonnull
        private final Rule ruleUsed;

        public AlreadyRuleAnnotateReportable(@Nonnull Annotable annotated, Rule rule) {
            this.annotated = annotated;
            this.ruleUsed = rule;
        }

        @Override
        @Nonnull
        public String getMessage() {
            TypePackageAndMethodFormatter formatter = Jack.getUserFriendlyFormatter();
            return "Preprocessor: rule '" + AddAnnotationStep.this.rule.getName() + "' from " + AddAnnotationStep.this.rule.getLocation().getDescription() + ": " + AddAnnotationStep.getElement(formatter, this.annotated) + " already annotated with @" + formatter.getName(AddAnnotationStep.this.annotationType) + " by rule '" + this.ruleUsed.getName() + "' from " + this.ruleUsed.getLocation().getDescription();
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.INFO;
        }
    }

    private final class AlreadySourceAnnotateReportable
    implements Reportable {
        @Nonnull
        private final Annotable annotated;

        public AlreadySourceAnnotateReportable(Annotable annotated) {
            this.annotated = annotated;
        }

        @Override
        @Nonnull
        public String getMessage() {
            TypePackageAndMethodFormatter formatter = Jack.getUserFriendlyFormatter();
            return "Preprocessor: rule '" + AddAnnotationStep.this.rule.getName() + "' from " + AddAnnotationStep.this.rule.getLocation().getDescription() + ": " + AddAnnotationStep.getElement(formatter, this.annotated) + " already annotated with @" + formatter.getName(AddAnnotationStep.this.annotationType);
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.INFO;
        }
    }

    private final class AnnotateReportable
    implements Reportable {
        @Nonnull
        private final Annotable annotated;

        public AnnotateReportable(Annotable annotated) {
            this.annotated = annotated;
        }

        @Override
        @Nonnull
        public String getMessage() {
            TypePackageAndMethodFormatter formatter = Jack.getUserFriendlyFormatter();
            return "Preprocessor: rule '" + AddAnnotationStep.this.rule.getName() + "' from " + AddAnnotationStep.this.rule.getLocation().getDescription() + ": annotates " + AddAnnotationStep.getElement(formatter, this.annotated) + " with @" + formatter.getName(AddAnnotationStep.this.annotationType);
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.INFO;
        }
    }
}

