/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.reporting;

import com.android.jack.reporting.CommonReporter;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.FileOrDirLocation;
import com.android.sched.util.location.Location;
import java.io.PrintWriter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@ImplementationName(iface=Reporter.class, name="default")
public class DefaultReporter
extends CommonReporter {
    @Override
    protected void printFilteredProblem(@Nonnull Reportable.ProblemLevel problemLevel, @Nonnull String message, @CheckForNull Location location) {
        StringBuilder messageBuffer = new StringBuilder(problemLevel.toString());
        if (location != null) {
            String filePath = null;
            Location currentLocation = location;
            ColumnAndLineLocation call = null;
            if (currentLocation instanceof ColumnAndLineLocation) {
                call = (ColumnAndLineLocation)currentLocation;
                currentLocation = call.getParentLocation();
            }
            if (currentLocation instanceof FileOrDirLocation) {
                filePath = ((FileOrDirLocation)currentLocation).getPath();
            }
            if (filePath != null) {
                messageBuffer.append(": ");
                messageBuffer.append(filePath);
                if (call != null && call.hasStartLine()) {
                    messageBuffer.append(':');
                    messageBuffer.append(call.getStartLine());
                    if (call.hasStartColumn()) {
                        messageBuffer.append('.');
                        messageBuffer.append(call.getStartColumn());
                        if (!call.hasEndLine() && call.hasEndColumn()) {
                            messageBuffer.append('-');
                            messageBuffer.append(call.getEndColumn());
                        }
                    }
                    if (call.hasEndLine()) {
                        messageBuffer.append('-');
                        messageBuffer.append(call.getEndLine());
                        if (call.hasStartColumn()) {
                            if (call.hasEndColumn()) {
                                messageBuffer.append('.');
                                messageBuffer.append(call.getEndColumn());
                            } else {
                                messageBuffer.append('.');
                                messageBuffer.append(call.getStartColumn());
                            }
                        }
                    }
                }
            }
        }
        messageBuffer.append(": ");
        messageBuffer.append(message);
        PrintWriter writer = (PrintWriter)this.writerByLevel.get((Object)problemLevel);
        if (writer == null) {
            writer = this.writerByDefault;
        }
        writer.println(messageBuffer.toString());
    }
}

