/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.reporting;

import com.android.jack.VerbosityLevel;
import com.android.sched.util.codec.VariableName;
import javax.annotation.Nonnull;

public interface Reportable {
    @Nonnull
    public String getMessage();

    @Nonnull
    public ProblemLevel getDefaultProblemLevel();

    @VariableName(value="level")
    public static enum ProblemLevel {
        ERROR(VerbosityLevel.ERROR),
        WARNING(VerbosityLevel.WARNING),
        INFO(VerbosityLevel.INFO);

        @Nonnull
        private final VerbosityLevel verbosityLevelThreshold;

        private ProblemLevel(VerbosityLevel verbosityLevelThreshold) {
            this.verbosityLevelThreshold = verbosityLevelThreshold;
        }

        public boolean isVisibleWith(@Nonnull VerbosityLevel verbosityLevel) {
            return verbosityLevel.ordinal() >= this.verbosityLevelThreshold.ordinal();
        }
    }
}

