/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.scheduling.adapter;

import com.android.jack.google.common.collect.Iterators;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.AdapterSchedulable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;

@Description(value="Adapts process on JSession to one or several processes on each of its JPackage")
@Name(value="JPackageAdapter")
public class JPackageAdapter
implements AdapterSchedulable<JSession, JPackage> {
    @Nonnull
    private Iterator<JPackage> process(@Nonnull JPackage pack) {
        ArrayList<JPackage> packages = new ArrayList<JPackage>(pack.getSubPackages());
        Iterator<JPackage> iter = packages.iterator();
        for (JPackage subPackage : packages) {
            iter = Iterators.concat(iter, this.process(subPackage));
        }
        return iter;
    }

    @Override
    @Nonnull
    public Iterator<JPackage> adapt(@Nonnull JSession session) {
        return Iterators.concat(Iterators.singletonIterator(session.getTopLevelPackage()), this.process(session.getTopLevelPackage()));
    }
}

