/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.config.id.Arzon;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.reporting.ReportableIOException;
import com.android.jack.reporting.Reporter;
import com.android.jack.shrob.obfuscation.FinalNames;
import com.android.jack.shrob.obfuscation.Mapping;
import com.android.jack.shrob.obfuscation.Obfuscation;
import com.android.jack.shrob.obfuscation.OriginalNameMarker;
import com.android.jack.shrob.obfuscation.OriginalNameTools;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.Produce;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.util.codec.WriterFileCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.WriterFilePropertyId;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Visitor that prints the mapping")
@Produce(value={Mapping.class})
@Constraint(need={FinalNames.class})
@Optional(value={@ToSupport(feature={Obfuscation.class}, add={@Constraint(need={OriginalNameMarker.class})})})
public class MappingPrinter
implements RunnableSchedulable<JSession> {
    @Nonnull
    public static final BooleanPropertyId MAPPING_OUTPUT_ENABLED = BooleanPropertyId.create("jack.obfuscation.mapping.dump", "Print the obfuscation mapping").addDefaultValue(false).addCategory(Arzon.class);
    @Nonnull
    public static final WriterFilePropertyId MAPPING_OUTPUT_FILE = WriterFilePropertyId.create("jack.obfuscation.mapping.dump.file", "File where the mapping will be emitted", new WriterFileCodec(FileOrDirectory.Existence.MAY_EXIST).allowStandardOutputOrError().allowCharset()).addDefaultValue("-").addCategory(Arzon.class);
    @Nonnull
    private final WriterFile file = ThreadConfig.get(MAPPING_OUTPUT_FILE);
    private static final String SEPARATOR = " -> ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@Nonnull JSession session) {
        CustomPrintWriter writer = this.file.getPrintWriter();
        try {
            Visitor visitor = new Visitor(writer);
            visitor.accept(session.getTypesToEmit());
        }
        finally {
            writer.close();
            try {
                writer.throwPendingException();
            }
            catch (IOException e) {
                session.getReporter().report(Reporter.Severity.FATAL, new ReportableIOException("Mapping", new CannotWriteException(ThreadConfig.get(MAPPING_OUTPUT_FILE), (Throwable)e)));
                session.abortEventually();
            }
        }
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final PrintWriter writer;

        public Visitor(@Nonnull PrintWriter writer) {
            this.writer = writer;
        }

        @Override
        public boolean visit(@Nonnull JDefinedClassOrInterface type) {
            StringBuilder info = new StringBuilder();
            OriginalNameTools.appendOriginalQualifiedName(info, type);
            info.append(MappingPrinter.SEPARATOR);
            info.append(GrammarActions.getSourceFormatter().getName(type));
            info.append(':');
            this.writer.println(info);
            return super.visit(type);
        }

        @Override
        public boolean visit(@Nonnull JField field) {
            StringBuilder info = new StringBuilder().append("    ");
            OriginalNameTools.appendOriginalQualifiedName(info, field.getType());
            info.append(' ');
            OriginalNameTools.appendOriginalName(info, field.getId());
            info.append(MappingPrinter.SEPARATOR);
            info.append(field.getName());
            this.writer.println(info);
            return super.visit(field);
        }

        @Override
        public boolean visit(@Nonnull JMethod method) {
            StringBuilder info = new StringBuilder().append("    ");
            OriginalNameTools.appendOriginalQualifiedName(info, method.getType());
            info.append(' ');
            OriginalNameTools.appendOriginalName(info, method.getMethodIdWide());
            info.append('(');
            Iterator<JParameter> iterator = method.getParams().iterator();
            while (iterator.hasNext()) {
                JParameter param = iterator.next();
                OriginalNameTools.appendOriginalQualifiedName(info, param.getType());
                if (!iterator.hasNext()) continue;
                info.append(',');
            }
            info.append(')');
            info.append(MappingPrinter.SEPARATOR);
            info.append(method.getName());
            this.writer.println(info);
            return super.visit(method);
        }
    }
}

