/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.shrob.obfuscation.NewMethodKeyMarker;
import com.android.jack.shrob.obfuscation.OneTimeHierarchyVisitor;
import com.android.jack.shrob.obfuscation.Renamer;
import com.android.jack.shrob.obfuscation.key.Key;
import com.android.jack.shrob.obfuscation.key.MethodKey;
import javax.annotation.Nonnull;

public class MethodInHierarchyFinder
extends OneTimeHierarchyVisitor {
    @Nonnull
    private final MethodKey methodKey;
    private boolean hasFoundMethodId = false;

    private MethodInHierarchyFinder(@Nonnull MethodKey methodKey) {
        this.methodKey = methodKey;
    }

    public void startVisit(@Nonnull JDefinedClassOrInterface type) {
        for (JMethod sameEnclosingTypeMethod : type.getMethods()) {
            JMethodIdWide id = sameEnclosingTypeMethod.getMethodId().getMethodIdWide();
            if (id.canBeVirtual() || Renamer.mustBeRenamed(id) || !Key.getKey(id).equals(this.methodKey)) continue;
            this.hasFoundMethodId = true;
            return;
        }
        this.visit(type);
        this.visitSuperTypes(type);
        this.visitSubTypes(type);
    }

    @Override
    public boolean doAction(@Nonnull JDefinedClassOrInterface type) {
        NewMethodKeyMarker marker = type.getMarker(NewMethodKeyMarker.class);
        if (marker != null && marker.getNewKeys().contains(this.methodKey)) {
            this.hasFoundMethodId = true;
            return false;
        }
        for (JMethod sameEnclosingTypeMethod : type.getMethods()) {
            JMethodIdWide id = sameEnclosingTypeMethod.getMethodId().getMethodIdWide();
            if (!id.canBeVirtual() || Renamer.mustBeRenamed(id) || !Key.getKey(id).equals(this.methodKey)) continue;
            this.hasFoundMethodId = true;
            return false;
        }
        return true;
    }

    public static boolean containsMethodKey(@Nonnull MethodKey methodKey, @Nonnull JMethodIdWide methodId) {
        MethodInHierarchyFinder visitor = new MethodInHierarchyFinder(methodKey);
        for (JMethod otherMethod : methodId.getMethods()) {
            visitor.startVisit(otherMethod.getEnclosingType());
        }
        return visitor.hasFoundMethodId;
    }
}

