/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.nameprovider;

import com.android.jack.shrob.obfuscation.key.Key;
import com.android.jack.shrob.obfuscation.nameprovider.NameProvider;
import java.util.Map;
import javax.annotation.Nonnull;

public class MappingNameProvider
implements NameProvider {
    @Nonnull
    private final NameProvider defaultNameProvider;
    @Nonnull
    private final Map<? extends Key, String> names;

    public MappingNameProvider(@Nonnull NameProvider defaultNameProvider, @Nonnull Map<? extends Key, String> names) {
        this.defaultNameProvider = defaultNameProvider;
        this.names = names;
    }

    @Override
    @Nonnull
    public String getNewName(@Nonnull Key key) {
        String newName = this.names.get(key);
        if (newName != null) {
            return newName;
        }
        return this.defaultNameProvider.getNewName(key);
    }

    @Override
    public boolean hasAlternativeName(@Nonnull Key key) {
        return !this.names.containsKey(key) && this.defaultNameProvider.hasAlternativeName(key);
    }
}

