/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.nameprovider;

import com.android.jack.shrob.obfuscation.key.Key;
import com.android.jack.shrob.obfuscation.nameprovider.NameProvider;
import java.util.Set;
import javax.annotation.Nonnull;

public class UniqueNameProvider
implements NameProvider {
    @Nonnull
    private final Set<String> names;
    @Nonnull
    private final NameProvider nameProvider;

    public UniqueNameProvider(@Nonnull NameProvider nameProvider, @Nonnull Set<String> existingNames) {
        this.nameProvider = nameProvider;
        this.names = existingNames;
    }

    @Override
    @Nonnull
    public String getNewName(@Nonnull Key key) {
        String newName = this.nameProvider.getNewName(key);
        while (this.names.contains(newName)) {
            String candidate = this.nameProvider.getNewName(key);
            assert (!candidate.equals(newName));
            newName = candidate;
        }
        this.names.add(newName);
        return newName;
    }

    @Override
    public boolean hasAlternativeName(@Nonnull Key key) {
        return this.nameProvider.hasAlternativeName(key);
    }
}

