/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.proguard;

import com.android.jack.antlr.runtime.ANTLRFileStream;
import com.android.jack.antlr.runtime.CharStream;
import com.android.jack.antlr.runtime.CommonTokenStream;
import com.android.jack.antlr.runtime.RecognitionException;
import com.android.jack.ir.formatter.BinarySignatureFormatter;
import com.android.jack.ir.formatter.SourceFormatter;
import com.android.jack.ir.formatter.TypeAndMethodFormatter;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.shrob.proguard.ProguardFileParsingException;
import com.android.jack.shrob.proguard.ProguardLexer;
import com.android.jack.shrob.proguard.ProguardParser;
import com.android.jack.shrob.proguard.RecoverableRecognitionException;
import com.android.jack.shrob.spec.AnnotationSpecification;
import com.android.jack.shrob.spec.ClassSpecification;
import com.android.jack.shrob.spec.ClassTypeSpecification;
import com.android.jack.shrob.spec.FieldSpecification;
import com.android.jack.shrob.spec.FilterSpecification;
import com.android.jack.shrob.spec.Flags;
import com.android.jack.shrob.spec.InheritanceSpecification;
import com.android.jack.shrob.spec.KeepModifier;
import com.android.jack.shrob.spec.MethodSpecification;
import com.android.jack.shrob.spec.ModifierSpecification;
import com.android.jack.shrob.spec.NameSpecification;
import com.android.jack.util.NamingTools;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class GrammarActions {
    public static final char SHROB_REGEX_PATH_SEPARATOR = '/';
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private static final TypeAndMethodFormatter signatureFormatter = BinarySignatureFormatter.getFormatter();
    @Nonnull
    private static final TypePackageAndMethodFormatter sourceFormatter = SourceFormatter.getFormatter();
    private static final String PRIMITIVE_TYPE_NON_VOID = "(boolean|byte|char|short|int|float|double|long)";

    private GrammarActions() {
    }

    @Nonnull
    public static TypeAndMethodFormatter getSignatureFormatter() {
        return signatureFormatter;
    }

    @Nonnull
    public static TypePackageAndMethodFormatter getSourceFormatter() {
        return sourceFormatter;
    }

    @Nonnull
    public static String getSignature(@Nonnull String name) {
        int lastOpeningBracketPos = name.lastIndexOf(91);
        if (lastOpeningBracketPos != -1) {
            String nameWithoutArray = name.substring(0, lastOpeningBracketPos);
            return '[' + GrammarActions.getSignature(nameWithoutArray);
        }
        StringBuilder sig = new StringBuilder();
        if (name.equals("boolean")) {
            sig.append('Z');
        } else if (name.equals("byte")) {
            sig.append('B');
        } else if (name.equals("char")) {
            sig.append('C');
        } else if (name.equals("short")) {
            sig.append('S');
        } else if (name.equals("int")) {
            sig.append('I');
        } else if (name.equals("float")) {
            sig.append('F');
        } else if (name.equals("double")) {
            sig.append('D');
        } else if (name.equals("long")) {
            sig.append('J');
        } else if (name.equals("void")) {
            sig.append('V');
        } else {
            sig.append(NamingTools.getTypeSignatureName(name));
        }
        return sig.toString();
    }

    @Nonnull
    static String getSourceNamePattern(@Nonnull String name, int dim) {
        assert (name != null);
        StringBuilder sig = new StringBuilder();
        if (name.equals("...")) {
            sig.append(".*");
        } else if (name.equals("***")) {
            sig.append(".*");
        } else if (name.equals("%")) {
            sig.append(PRIMITIVE_TYPE_NON_VOID);
        } else if (name.equals("**")) {
            sig.append("[^\\[\\[]*(?<!(boolean|byte|char|short|int|float|double|long))");
        } else {
            sig.append(GrammarActions.convertNameToRegex(name, FilterSeparator.CLASS));
        }
        for (int i = 0; i < dim; ++i) {
            sig.append("\\[\\]");
        }
        return sig.toString();
    }

    @Nonnull
    private static String convertNameToRegex(@Nonnull String name, @Nonnull FilterSeparator separator) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '?': {
                    sb.append(separator.singleCharWilcard);
                    continue block5;
                }
                case '*': {
                    int j = i + 1;
                    if (j < name.length() && name.charAt(j) == '*') {
                        sb.append(separator.multipleCharWildcardWithSeparator);
                        ++i;
                        continue block5;
                    }
                    sb.append(separator.multipleCharWildcard);
                    continue block5;
                }
                case '$': {
                    sb.append("\\$");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Nonnull
    static NameSpecification name(String name, @Nonnull FilterSeparator separator) {
        assert (name != null);
        String transformedName = "^" + GrammarActions.convertNameToRegex(name, separator) + "$";
        Pattern pattern = Pattern.compile(transformedName);
        return new NameSpecification(pattern);
    }

    static void addModifier(@Nonnull ModifierSpecification modSpec, @Nonnull ModifierSpecification.Modifier modifier, boolean hasNegator) {
        modSpec.addModifier(modifier, hasNegator);
    }

    static void addAccessFlag(@Nonnull ModifierSpecification modSpec, @Nonnull ModifierSpecification.AccessFlags accessFlag, boolean hasNegator) {
        modSpec.addAccessFlag(accessFlag, hasNegator);
    }

    @Nonnull
    static ClassTypeSpecification classType(ClassTypeSpecification.TypeEnum type, boolean hasNegator) {
        assert (type != null);
        ClassTypeSpecification classSpec = new ClassTypeSpecification(type);
        classSpec.setNegator(hasNegator);
        return classSpec;
    }

    @Nonnull
    static InheritanceSpecification createInheritance(String className, boolean hasNameNegator, @CheckForNull AnnotationSpecification annotationType) {
        NameSpecification nameSpec = GrammarActions.name(className, FilterSeparator.CLASS);
        nameSpec.setNegator(hasNameNegator);
        return new InheritanceSpecification(nameSpec, annotationType);
    }

    @Nonnull
    static AnnotationSpecification annotation(String annotationName, boolean hasNameNegator) {
        NameSpecification name = GrammarActions.name(annotationName, FilterSeparator.CLASS);
        name.setNegator(hasNameNegator);
        return new AnnotationSpecification(name);
    }

    @Nonnull
    static ClassSpecification classSpec(List<NameSpecification> classNames, @Nonnull ClassTypeSpecification classType, AnnotationSpecification annotation, @Nonnull ModifierSpecification modifier) {
        ClassSpecification classSpec = new ClassSpecification(classNames, classType, annotation);
        classSpec.setModifier(modifier);
        return classSpec;
    }

    static NameSpecification className(String name, boolean hasNameNegator) {
        NameSpecification nameSpec = name.equals("*") ? GrammarActions.name("**", FilterSeparator.CLASS) : GrammarActions.name(name, FilterSeparator.CLASS);
        nameSpec.setNegator(hasNameNegator);
        return nameSpec;
    }

    static void method(@Nonnull ClassSpecification classSpec, @CheckForNull AnnotationSpecification annotationType, @CheckForNull String typeSigRegex, String name, @Nonnull String signature, @CheckForNull ModifierSpecification modifier) {
        Pattern pattern;
        assert (name != null);
        String fullName = "^" + GrammarActions.convertNameToRegex(name, FilterSeparator.CLASS);
        fullName = fullName + signature;
        NameSpecification typeSignature = null;
        if (typeSigRegex != null) {
            pattern = Pattern.compile("^" + typeSigRegex + "$");
            typeSignature = new NameSpecification(pattern);
        }
        fullName = fullName + "$";
        pattern = Pattern.compile(fullName);
        classSpec.add(new MethodSpecification(new NameSpecification(pattern), modifier, typeSignature, annotationType));
    }

    static void fieldOrAnyMember(@Nonnull ClassSpecification classSpec, @CheckForNull AnnotationSpecification annotationType, @CheckForNull String typeSig, String name, @Nonnull ModifierSpecification modifier, @Nonnull CharStream inputStream) throws RecognitionException {
        assert (name != null);
        if (typeSig == null) {
            if (!name.equals("*")) {
                throw new RecognitionException(inputStream);
            }
            GrammarActions.method(classSpec, annotationType, GrammarActions.getSourceNamePattern("***", 0), "*", "\\(" + GrammarActions.getSourceNamePattern("...", 0) + "\\)", modifier);
        }
        GrammarActions.field(classSpec, annotationType, typeSig, name, modifier, inputStream);
    }

    static void field(@Nonnull ClassSpecification classSpec, @CheckForNull AnnotationSpecification annotationType, @CheckForNull String typeSigRegex, String name, @Nonnull ModifierSpecification modifier, @Nonnull CharStream inputStream) throws RecognitionException {
        assert (name != null);
        NameSpecification typeSignature = null;
        if (typeSigRegex != null) {
            Pattern pattern = Pattern.compile("^" + typeSigRegex + "$");
            typeSignature = new NameSpecification(pattern);
        } else if (!name.equals("*")) {
            throw new RecognitionException(inputStream);
        }
        classSpec.add(new FieldSpecification(GrammarActions.name(name, FilterSeparator.GENERAL), modifier, typeSignature, annotationType));
    }

    @CheckForNull
    private static ProguardParser createParserFromFile(@Nonnull File file) throws ProguardFileParsingException {
        try {
            AbstractStreamFile.check(file, new FileLocation(file.getPath()));
            ProguardParser parser = GrammarActions.createParserCommon(new ANTLRFileStream(file.getPath()));
            return parser;
        }
        catch (NoSuchFileException e) {
            throw new ProguardFileParsingException(e);
        }
        catch (NotFileException e) {
            throw new ProguardFileParsingException(e);
        }
        catch (IOException e) {
            throw new ProguardFileParsingException(e);
        }
    }

    @Nonnull
    private static ProguardParser createParserCommon(@Nonnull CharStream stream) {
        ProguardLexer lexer = new ProguardLexer(stream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ProguardParser parser = new ProguardParser(tokens);
        return parser;
    }

    public static void parse(String proguardFileName, String baseDir, @Nonnull Flags flags) throws RecognitionException, ProguardFileParsingException {
        assert (proguardFileName != null);
        assert (baseDir != null);
        File proguardFile = GrammarActions.getFileFromBaseDir(baseDir, proguardFileName);
        ProguardParser parser = GrammarActions.createParserFromFile(proguardFile);
        if (parser != null) {
            try {
                parser.prog(flags, proguardFile.getParentFile().getPath());
            }
            catch (RecoverableRecognitionException e) {
                throw e.getCause();
            }
        }
    }

    static void addKeepClassMembers(@Nonnull Flags flags, ClassSpecification classSpecification, @Nonnull KeepModifier keepModifier) {
        assert (classSpecification != null);
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassMembers(classSpecification);
    }

    static void addKeepClassSpecification(@Nonnull Flags flags, ClassSpecification classSpecification, @Nonnull KeepModifier keepModifier) {
        assert (classSpecification != null);
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassSpecification(classSpecification);
    }

    static void addKeepClassesWithMembers(@Nonnull Flags flags, ClassSpecification classSpecification, @Nonnull KeepModifier keepModifier) {
        assert (classSpecification != null);
        classSpecification.setKeepModifier(keepModifier);
        flags.addKeepClassesWithMembers(classSpecification);
    }

    static void mapping(@Nonnull Flags flags, String baseDir, String mappingFilename) {
        assert (mappingFilename != null);
        assert (baseDir != null);
        File mappingFile = GrammarActions.getFileFromBaseDir(baseDir, mappingFilename);
        if (!mappingFile.exists()) {
            logger.log(Level.WARNING, "Mapping file {0} not found", mappingFile.getPath());
        } else {
            flags.setObfuscationMapping(mappingFile);
        }
    }

    static void filter(@Nonnull List<FilterSpecification> filter, boolean negator, String filterName, @Nonnull FilterSeparator separator) {
        assert (filterName != null);
        filter.add(new FilterSpecification(GrammarActions.name(filterName, separator), negator));
    }

    static void attributeFilter(@Nonnull Flags flags, @Nonnull List<FilterSpecification> attributeSpec) {
        flags.addAllKeepAttribute(attributeSpec);
    }

    static void packageFilter(@Nonnull Flags flags, @Nonnull List<FilterSpecification> packageSpec) {
        flags.addAllKeepPackageName(packageSpec);
    }

    static void obfuscationDictionary(@Nonnull Flags flags, String baseDir, String fileName) {
        assert (fileName != null);
        assert (baseDir != null);
        File dictionary = GrammarActions.getFileFromBaseDir(baseDir, fileName);
        if (!dictionary.exists()) {
            throw new AssertionError((Object)(dictionary.getPath() + " not found"));
        }
        flags.setObfuscationDictionary(dictionary);
    }

    static void classObfuscationDictionary(@Nonnull Flags flags, String baseDir, String fileName) {
        assert (fileName != null);
        assert (baseDir != null);
        File dictionary = GrammarActions.getFileFromBaseDir(baseDir, fileName);
        if (!dictionary.exists()) {
            throw new AssertionError((Object)(dictionary.getPath() + " not found"));
        }
        flags.setClassObfuscationDictionary(dictionary);
    }

    static void packageObfuscationDictionary(@Nonnull Flags flags, String baseDir, String fileName) {
        assert (fileName != null);
        assert (baseDir != null);
        File dictionary = GrammarActions.getFileFromBaseDir(baseDir, fileName);
        if (!dictionary.exists()) {
            throw new AssertionError((Object)(dictionary.getPath() + " not found"));
        }
        flags.setPackageObfuscationDictionary(dictionary);
    }

    static void inJars(@Nonnull Flags flags, String baseDir, String inJars) {
        assert (inJars != null);
        assert (baseDir != null);
        List<File> pathList = GrammarActions.getPathFromBaseDirAsList(baseDir, inJars);
        flags.addInJars(pathList);
    }

    static void outJars(@Nonnull Flags flags, String baseDir, String outJars) {
        assert (outJars != null);
        assert (baseDir != null);
        List<File> pathList = GrammarActions.getPathFromBaseDirAsList(baseDir, outJars);
        flags.addOutJars(pathList);
        if (flags.getOutJars().size() != 1) {
            throw new AssertionError((Object)"Only one archive supported with -outjars for now");
        }
    }

    static void libraryJars(@Nonnull Flags flags, String baseDir, String libraryJars) {
        assert (libraryJars != null);
        assert (baseDir != null);
        flags.addLibraryJars(GrammarActions.getPathFromBaseDir(baseDir, libraryJars));
    }

    static void outputMapping(@Nonnull Flags flags, String baseDir, @CheckForNull String outputMapping) {
        assert (baseDir != null);
        flags.setPrintMapping(true);
        if (outputMapping != null) {
            File mappingFile = GrammarActions.getFileFromBaseDir(baseDir, outputMapping);
            flags.setOutputMapping(mappingFile);
        }
    }

    static void repackageClasses(@Nonnull Flags flags, @CheckForNull String newPackage) {
        if (newPackage == null) {
            newPackage = "";
        }
        flags.setPackageForRenamedClasses(newPackage);
        flags.addKeepPackageNames(GrammarActions.name(newPackage, FilterSeparator.GENERAL), false);
    }

    static void flattenPackageHierarchy(@Nonnull Flags flags, @CheckForNull String newPackage) {
        if (newPackage == null) {
            newPackage = "";
        }
        flags.setPackageForFlatHierarchy(newPackage);
        flags.addKeepPackageNames(GrammarActions.name(newPackage, FilterSeparator.GENERAL), false);
    }

    static void dontUseMixedCaseClassnames(@Nonnull Flags flags) {
        flags.setUseMixedCaseClassName(false);
    }

    static void useUniqueClassMemberNames(@Nonnull Flags flags) {
        flags.setUseUniqueClassMemberNames(true);
    }

    @Nonnull
    private static File getFileFromBaseDir(@Nonnull String baseDir, @Nonnull String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }

    @Nonnull
    private static String getPathFromBaseDir(@Nonnull String baseDir, @Nonnull String path) {
        List<File> pathList = GrammarActions.getPathFromBaseDirAsList(baseDir, path);
        StringBuilder sb = new StringBuilder();
        Iterator<File> iter = pathList.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().getPath());
            if (!iter.hasNext()) continue;
            sb.append(File.pathSeparatorChar);
        }
        return sb.toString();
    }

    @Nonnull
    private static List<File> getPathFromBaseDirAsList(@Nonnull String baseDir, @Nonnull String path) {
        String[] pathElements = path.split(File.pathSeparator);
        ArrayList<File> pathList = new ArrayList<File>(pathElements.length);
        for (String pathElement : pathElements) {
            pathList.add(GrammarActions.getFileFromBaseDir(baseDir, pathElement));
        }
        return pathList;
    }

    static void adaptClassStrings(@Nonnull Flags flags, @Nonnull List<FilterSpecification> filter) {
        flags.addAdaptClassStrings(filter);
    }

    static void printUnsupportedFlag(String flag) {
    }

    static void printseeds(@Nonnull Flags flags, String baseDir, @CheckForNull String fileName) {
        assert (baseDir != null);
        flags.setPrintSeeds(true);
        if (fileName != null) {
            flags.setSeedsFile(GrammarActions.getFileFromBaseDir(baseDir, fileName));
        }
    }

    static void adaptResourceFileNames(@Nonnull Flags flags, @Nonnull List<FilterSpecification> filter) {
        flags.adaptResourceFileNames(filter);
    }

    static void renameSourcefileAttribute(@Nonnull Flags flags, @CheckForNull String newSourceFileName) {
        if (newSourceFileName == null) {
            newSourceFileName = "";
        }
        flags.setRenameSourceFileAttribute(newSourceFileName);
    }

    static void adaptResourceFileContents(@Nonnull Flags flags, @Nonnull List<FilterSpecification> filter) {
        flags.adaptResourceFileContents(filter);
    }

    static enum FilterSeparator {
        GENERAL(".", "[^./]*", ".*"),
        FILE(".", "[^/]*", ".*"),
        CLASS("[^.]", "[^.]*", "[^\\[\\]]*"),
        ATTRIBUTE(".", ".*", ".*");

        @Nonnull
        private final String singleCharWilcard;
        @Nonnull
        private final String multipleCharWildcard;
        @Nonnull
        private final String multipleCharWildcardWithSeparator;

        private FilterSeparator(@Nonnull String singleCharWilcard, String multipleCharWildcard, String multipleCharWildcardWithSeparator) {
            this.singleCharWilcard = singleCharWilcard;
            this.multipleCharWildcard = multipleCharWildcard;
            this.multipleCharWildcardWithSeparator = multipleCharWildcardWithSeparator;
        }
    }
}

