/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.shrob.spec.AnnotationSpecification;
import com.android.jack.shrob.spec.ModifierSpecification;
import com.android.jack.shrob.spec.NameSpecification;
import com.android.jack.shrob.spec.Specification;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class MethodSpecification
implements Specification<JMethod> {
    @CheckForNull
    private final AnnotationSpecification annotationType;
    @CheckForNull
    private final ModifierSpecification modifier;
    @CheckForNull
    private final NameSpecification type;
    @Nonnull
    private final NameSpecification fullSourceName;

    public MethodSpecification(@Nonnull NameSpecification sigPattern, @CheckForNull ModifierSpecification modifier, @CheckForNull NameSpecification type, @CheckForNull AnnotationSpecification annotationType) {
        this.fullSourceName = sigPattern;
        this.modifier = modifier;
        this.annotationType = annotationType;
        this.type = type;
    }

    @Override
    public boolean matches(@Nonnull JMethod t) {
        if (this.modifier != null && !this.modifier.matches(t)) {
            return false;
        }
        if (this.annotationType != null && !this.annotationType.matches(t.getAnnotations())) {
            return false;
        }
        if (this.type != null && !this.type.matches(GrammarActions.getSourceFormatter().getName(t.getType()))) {
            return false;
        }
        String signature = GrammarActions.getSourceFormatter().getNameWithoutReturnType(t.getMethodIdWide());
        if (t instanceof JConstructor) {
            String methodName = signature.replace("<init>", t.getEnclosingType().getName());
            if (this.fullSourceName.matches(methodName)) {
                return true;
            }
            methodName = signature.replace("<init>", GrammarActions.getSourceFormatter().getName(t.getEnclosingType()));
            if (this.fullSourceName.matches(methodName)) {
                return true;
            }
        }
        return this.fullSourceName.matches(signature);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("method: ");
        if (this.annotationType != null) {
            sb.append(this.annotationType);
            sb.append(' ');
        }
        if (this.modifier != null) {
            sb.append(this.modifier);
            sb.append(' ');
        }
        if (this.type != null) {
            sb.append(this.type);
            sb.append(' ');
        }
        sb.append(this.fullSourceName);
        sb.append(';');
        return sb.toString();
    }
}

