/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tonicsystems.jarjar;

import com.android.jack.tonicsystems.jarjar.Wildcard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PackageRemapper {
    @Nonnull
    private final List<Wildcard> wildcards;
    @Nonnull
    private static final String RESOURCE_SUFFIX = "RESOURCE";
    @Nonnull
    private static final Pattern ARRAY_FOR_NAME_PATTERN = Pattern.compile("\\[L[\\p{javaJavaIdentifierPart}\\.]+?;");
    @Nonnull
    private final Map<String, String> typeCache = new HashMap<String, String>();
    @Nonnull
    private final Map<String, String> pathCache = new HashMap<String, String>();
    @Nonnull
    private final Map<Object, String> valueCache = new HashMap<Object, String>();

    public PackageRemapper(@Nonnull List<Wildcard> wildcards) {
        this.wildcards = wildcards;
    }

    static boolean isArrayForName(@Nonnull String value) {
        return ARRAY_FOR_NAME_PATTERN.matcher(value).matches();
    }

    @CheckForNull
    private String map(@Nonnull String key) {
        String s = this.typeCache.get(key);
        if (s == null) {
            s = this.replaceHelper(key);
            if (key.equals(s)) {
                s = null;
            }
            this.typeCache.put(key, s);
        }
        return s;
    }

    @Nonnull
    public String mapPath(@Nonnull String path) {
        String s = this.pathCache.get(path);
        if (s == null) {
            String end;
            s = path;
            int slash = s.lastIndexOf(47);
            if (slash < 0) {
                end = s;
                s = RESOURCE_SUFFIX;
            } else {
                end = s.substring(slash + 1);
                s = s.substring(0, slash + 1) + RESOURCE_SUFFIX;
            }
            boolean absolute = s.startsWith("/");
            if (absolute) {
                s = s.substring(1);
            }
            s = this.replaceHelper(s);
            if (absolute) {
                s = "/" + s;
            }
            if (s.indexOf(RESOURCE_SUFFIX) < 0) {
                return path;
            }
            s = s.substring(0, s.length() - RESOURCE_SUFFIX.length()) + end;
            this.pathCache.put(path, s);
        }
        return s;
    }

    @Nonnull
    public String mapValue(@Nonnull String value) {
        String s = this.valueCache.get(value);
        if (s == null) {
            s = value;
            if (PackageRemapper.isArrayForName(s)) {
                String desc1 = s.replace('.', '/');
                String desc2 = this.mapDesc(desc1);
                if (!desc2.equals(desc1)) {
                    return desc2.replace('/', '.');
                }
            } else if ((s = this.mapPath(s)).equals(value)) {
                boolean hasSlash;
                boolean hasDot = s.indexOf(46) >= 0;
                boolean bl = hasSlash = s.indexOf(47) >= 0;
                if (!hasDot || !hasSlash) {
                    s = hasDot ? this.replaceHelper(s.replace('.', '/')).replace('/', '.') : this.replaceHelper(s);
                }
            }
            this.valueCache.put(value, s);
        }
        return s;
    }

    @Nonnull
    private String replaceHelper(@Nonnull String value) {
        for (Wildcard wildcard : this.wildcards) {
            String test = wildcard.replace(value);
            if (test == null) continue;
            return test;
        }
        return value;
    }

    @Nonnull
    private String mapDesc(@Nonnull String desc) {
        if (desc.startsWith("[")) {
            return "[" + this.mapDesc(desc.substring(1));
        }
        if (desc.startsWith("L")) {
            assert (desc.endsWith(";"));
            String newDesc = this.map(desc.substring(1, desc.length() - 1));
            if (newDesc != null) {
                return "L" + newDesc + ";";
            }
        }
        return desc;
    }
}

