/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.merger;

import com.android.jack.Jack;
import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.io.FieldId;
import com.android.jack.dx.io.MethodHandleId;
import com.android.jack.dx.io.MethodId;
import com.android.jack.dx.io.ProtoId;
import com.android.jack.dx.io.TypeList;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstIndexMap;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.type.Prototype;
import com.android.jack.dx.rop.type.StdTypeList;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.tools.merger.FieldIdOverflowException;
import com.android.jack.tools.merger.MergerTools;
import com.android.jack.tools.merger.MergingOverflowException;
import com.android.jack.tools.merger.MethodHandleIdOverflowException;
import com.android.jack.tools.merger.MethodIdOverflowException;
import com.android.jack.tools.merger.PrototypedOverflowException;
import com.android.jack.tools.merger.TypeIdOverflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ConstantManager
extends MergerTools {
    @Nonnull
    private final Map<String, CstString> string2CstStrings = new HashMap<String, CstString>();
    @Nonnull
    private final HashSet<CstPrototypeRef> cstPrototypeRefs = new HashSet();
    @Nonnull
    private final HashSet<CstFieldRef> cstFieldRefs = new HashSet();
    @Nonnull
    private final HashSet<CstMethodRef> cstMethodRefs = new HashSet();
    @Nonnull
    private final HashSet<Type> types = new HashSet();
    @Nonnull
    private final HashSet<CstMethodHandleRef> cstMethodHandleRefs = new HashSet();

    @Nonnull
    public Collection<CstString> getCstStrings() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.string2CstStrings.values());
    }

    @Nonnull
    public Collection<CstFieldRef> getCstFieldRefs() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.cstFieldRefs);
    }

    @Nonnull
    public Collection<CstMethodRef> getCstMethodRefs() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.cstMethodRefs);
    }

    @Nonnull
    public Collection<Type> getTypes() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.types);
    }

    @Nonnull
    public Collection<CstPrototypeRef> getCstPrototypeRefs() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.cstPrototypeRefs);
    }

    @Nonnull
    public CstIndexMap addDexFile(@Nonnull DexBuffer dexBuffer) throws MergingOverflowException {
        CstIndexMap cstIndexMap = new CstIndexMap(dexBuffer);
        ArrayList<String> cstStringsNewlyAdded = new ArrayList<String>();
        ArrayList<CstPrototypeRef> cstPrototypeRefsNewlyAdded = new ArrayList<CstPrototypeRef>();
        ArrayList<CstFieldRef> cstFieldRefsNewlyAdded = new ArrayList<CstFieldRef>();
        ArrayList<CstMethodRef> cstMethodRefsNewlyAdded = new ArrayList<CstMethodRef>();
        ArrayList<Type> typesNewlyAdded = new ArrayList<Type>();
        ArrayList<CstMethodHandleRef> cstMethodHandleRefsNewlyAdded = new ArrayList<CstMethodHandleRef>();
        int idx = 0;
        for (String string : dexBuffer.strings()) {
            CstString cstString = this.string2CstStrings.get(string);
            if (cstString == null) {
                cstString = new CstString(string);
                this.string2CstStrings.put(string, cstString);
                cstStringsNewlyAdded.add(string);
            }
            cstIndexMap.addStringMapping(idx++, cstString);
        }
        idx = 0;
        List<String> typeNames = dexBuffer.typeNames();
        for (String typeNameDesc : typeNames) {
            Type type = null;
            type = typeNameDesc.equals(Type.VOID.getDescriptor().getString()) ? Type.VOID : Type.intern(typeNameDesc);
            if (this.types.add(type)) {
                typesNewlyAdded.add(type);
            }
            cstIndexMap.addTypeMapping(idx++, type);
        }
        idx = 0;
        for (FieldId fieldId : dexBuffer.fieldIds()) {
            CstFieldRef cstFieldRef = new CstFieldRef(cstIndexMap.getType(fieldId.getDeclaringClassIndex()), cstIndexMap.getCstString(fieldId.getNameIndex()), cstIndexMap.getType(fieldId.getTypeIndex()));
            if (this.cstFieldRefs.add(cstFieldRef)) {
                cstFieldRefsNewlyAdded.add(cstFieldRef);
            }
            cstIndexMap.addFieldMapping(idx++, cstFieldRef);
        }
        idx = 0;
        List<ProtoId> list = dexBuffer.protoIds();
        for (ProtoId protoId : list) {
            Prototype prototype = Prototype.intern(this.getStdTypeList(cstIndexMap, dexBuffer.readTypeList(protoId.getParametersOffset())), cstIndexMap.getType(protoId.getReturnTypeIndex()));
            CstPrototypeRef cstProtoRef = new CstPrototypeRef(prototype);
            if (this.cstPrototypeRefs.add(cstProtoRef)) {
                cstPrototypeRefsNewlyAdded.add(cstProtoRef);
            }
            cstIndexMap.addPrototypeMapping(idx++, cstProtoRef);
        }
        idx = 0;
        for (MethodId methodId : dexBuffer.methodIds()) {
            int protoIdx = methodId.getProtoIndex();
            CstMethodRef cstMethodRef = new CstMethodRef(cstIndexMap.getType(methodId.getDeclaringClassIndex()), cstIndexMap.getCstString(methodId.getNameIndex()), cstIndexMap.getCstPrototype(protoIdx).getPrototype());
            if (this.cstMethodRefs.add(cstMethodRef)) {
                cstMethodRefsNewlyAdded.add(cstMethodRef);
            }
            cstIndexMap.addMethodMapping(idx++, cstMethodRef);
        }
        idx = 0;
        for (MethodHandleId methodHandleId : dexBuffer.methodHandleIds()) {
            CstMethodHandleRef cstMethodHandleRef;
            CstMethodHandleRef.MethodHandleKind kind = methodHandleId.getKind();
            switch (kind) {
                case PUT_INSTANCE: 
                case PUT_STATIC: 
                case GET_INSTANCE: 
                case GET_STATIC: {
                    cstMethodHandleRef = new CstMethodHandleRef(kind, cstIndexMap.getCstFieldRef(methodHandleId.getMemberIndex()));
                    break;
                }
                case INVOKE_CONSTRUCTOR: 
                case INVOKE_INSTANCE: 
                case INVOKE_STATIC: {
                    cstMethodHandleRef = new CstMethodHandleRef(kind, cstIndexMap.getCstMethodRef(methodHandleId.getMemberIndex()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.cstMethodHandleRefs.add(cstMethodHandleRef)) {
                cstMethodHandleRefsNewlyAdded.add(cstMethodHandleRef);
            }
            cstIndexMap.addMethodHandleMapping(idx++, cstMethodHandleRef);
        }
        idx = 0;
        for (Integer callSiteRefIdx : dexBuffer.callSiteIds()) {
            cstIndexMap.addCallSiteMapping(idx++, dexBuffer.readCstCallSiteRef(cstIndexMap, callSiteRefIdx));
        }
        if (this.cstMethodHandleRefs.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, typesNewlyAdded, cstPrototypeRefsNewlyAdded, cstMethodHandleRefsNewlyAdded);
            throw new MethodHandleIdOverflowException();
        }
        if (this.cstFieldRefs.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, typesNewlyAdded, cstPrototypeRefsNewlyAdded, cstMethodHandleRefsNewlyAdded);
            throw new FieldIdOverflowException();
        }
        if (this.cstMethodRefs.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, typesNewlyAdded, cstPrototypeRefsNewlyAdded, cstMethodHandleRefsNewlyAdded);
            throw new MethodIdOverflowException();
        }
        if (this.types.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, typesNewlyAdded, cstPrototypeRefsNewlyAdded, cstMethodHandleRefsNewlyAdded);
            throw new TypeIdOverflowException();
        }
        if (this.cstPrototypeRefs.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, typesNewlyAdded, cstPrototypeRefsNewlyAdded, cstMethodHandleRefsNewlyAdded);
            throw new PrototypedOverflowException();
        }
        return cstIndexMap;
    }

    private void removeItems(@Nonnull List<String> cstStringsToRemove, @Nonnull List<CstFieldRef> cstFieldRefsToRemove, @Nonnull List<CstMethodRef> cstMethodRefsToRemove, @Nonnull List<Type> cstTypesToRemove, @Nonnull List<CstPrototypeRef> cstPrototypeRefsToRemove, @Nonnull List<CstMethodHandleRef> cstMethodHandleRefsToRemove) {
        this.string2CstStrings.keySet().removeAll(cstStringsToRemove);
        this.cstFieldRefs.removeAll(cstFieldRefsToRemove);
        this.cstMethodRefs.removeAll(cstMethodRefsToRemove);
        this.types.removeAll(cstTypesToRemove);
        this.cstPrototypeRefs.removeAll(cstPrototypeRefsToRemove);
        this.cstMethodHandleRefs.removeAll(cstMethodHandleRefsToRemove);
    }

    @Nonnull
    private StdTypeList getStdTypeList(@Nonnull CstIndexMap cstIndexMap, @Nonnull TypeList typeList) {
        short[] type = typeList.getTypes();
        int typesLength = type.length;
        StdTypeList stdTypeList = new StdTypeList(typesLength);
        for (int i = 0; i < typesLength; ++i) {
            stdTypeList.set(i, cstIndexMap.getType(type[i]));
        }
        stdTypeList.setImmutable();
        return stdTypeList;
    }

    public boolean validate(@Nonnull DexFile dexFile) {
        return dexFile.getStringIds().items().size() == this.string2CstStrings.size() && dexFile.getFieldIds().items().size() == this.cstFieldRefs.size() && dexFile.getMethodIds().items().size() == this.cstMethodRefs.size() && dexFile.getTypeIds().items().size() == this.types.size();
    }
}

