/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JAbsentArrayDimension;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.InitInNewArray;
import com.android.jack.transformations.ast.MultiDimensionNewArray;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Remove new array with multiple dimension.")
@Name(value="MultiDimensionNewArrayRemover")
@Transform(remove={MultiDimensionNewArray.class, ThreeAddressCodeForm.class}, add={JNewArray.class, JMethodCall.class, JClassLiteral.class, JDynamicCastOperation.class, InitInNewArray.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class MultiDimensionNewArrayRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JClass jlo = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);
    @Nonnull
    private final JClass jlc = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_CLASS);
    @Nonnull
    private final JClass reflectArrayType = Jack.getSession().getPhantomLookup().getClass("Ljava/lang/reflect/Array;");
    @Nonnull
    private final JArrayType intArrayType = Jack.getSession().getLookup().getArrayType(JPrimitiveType.JPrimitiveTypeEnum.INT.getType(), 1);
    @Nonnull
    private final JMethodId newInstance;

    public MultiDimensionNewArrayRemover() {
        ArrayList<JReferenceType> argsType = new ArrayList<JReferenceType>(2);
        argsType.add(this.jlc);
        argsType.add(this.intArrayType);
        this.newInstance = this.reflectArrayType.getOrCreateMethodId("newInstance", argsType, MethodKind.STATIC, this.jlo);
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr);
        visitor.accept(method);
        tr.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JNewArray newArray) {
            List<JExpression> presentDimensions;
            int nbPresentDimensions;
            List<JExpression> allDims = newArray.getDims();
            if (!allDims.isEmpty() && (nbPresentDimensions = (presentDimensions = this.getPresentDimensions(allDims)).size()) > 1) {
                SourceInfo sourceInfo = newArray.getSourceInfo();
                JMethodCall call = new JMethodCall(sourceInfo, null, MultiDimensionNewArrayRemover.this.reflectArrayType, MultiDimensionNewArrayRemover.this.newInstance, MultiDimensionNewArrayRemover.this.newInstance.getMethodIdWide().canBeVirtual());
                call.addArg(new JClassLiteral(sourceInfo, this.getComponentTypeForNewInstance(newArray, nbPresentDimensions)));
                call.addArg(JNewArray.createWithInits(sourceInfo, MultiDimensionNewArrayRemover.this.intArrayType, presentDimensions));
                this.tr.append(new Replace(newArray, new JDynamicCastOperation(sourceInfo, (JExpression)call, newArray.getArrayType())));
            }
            return super.visit(newArray);
        }

        @Nonnull
        private JType getComponentTypeForNewInstance(@Nonnull JNewArray newArray, @Nonnegative int nbPresentDim) {
            JType componentType = newArray.getArrayType();
            for (int i = 0; i < nbPresentDim; ++i) {
                componentType = componentType.getElementType();
            }
            return componentType;
        }

        @Nonnull
        private List<JExpression> getPresentDimensions(@Nonnull List<JExpression> newArrayDims) {
            ArrayList<JExpression> presentDims = new ArrayList<JExpression>(newArrayDims.size());
            boolean inPresentDims = true;
            for (JExpression expression : newArrayDims) {
                if (expression instanceof JAbsentArrayDimension) {
                    inPresentDims = false;
                    continue;
                }
                assert (inPresentDims);
                presentDims.add(expression);
            }
            return presentDims;
        }
    }
}

