/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Transform(add={JLocalRef.class, JParameterRef.class, JAsgOperation.NonReusedAsg.class, JMultiExpression.class, JFieldRef.class, JArrayRef.class}, remove={ThreeAddressCodeForm.class})
@Use(value={LocalVarCreator.class})
public class SideEffectExtractor {
    @Nonnull
    protected final LocalVarCreator lvCreator;

    public SideEffectExtractor(@Nonnull LocalVarCreator lvCreator) {
        this.lvCreator = lvCreator;
    }

    @CheckForNull
    private JExpression extract(@Nonnull List<JExpression> extracted, @CheckForNull JExpression toExtract, @Nonnull TransformationRequest tr) {
        if (toExtract != null) {
            SourceInfo sourceInfo = toExtract.getSourceInfo();
            if (toExtract instanceof JLocalRef) {
                return ((JLocalRef)toExtract).getLocal().makeRef(sourceInfo);
            }
            if (toExtract instanceof JParameterRef) {
                return ((JParameterRef)toExtract).getParameter().makeRef(sourceInfo);
            }
            JLocal tmp = this.lvCreator.createTempLocal(toExtract.getType(), sourceInfo, tr);
            JAsgOperation asg = new JAsgOperation(sourceInfo, tmp.makeRef(sourceInfo), toExtract);
            extracted.add(asg);
            tr.append(new Replace(toExtract, tmp.makeRef(sourceInfo)));
            return tmp.makeRef(sourceInfo);
        }
        return null;
    }

    @Nonnull
    private JFieldRef extractInstance(@Nonnull JFieldRef ref, @Nonnull TransformationRequest tr) {
        SourceInfo sourceInfo = ref.getSourceInfo();
        ArrayList<JExpression> extracted = new ArrayList<JExpression>();
        JExpression newInstance = this.extract(extracted, ref.getInstance(), tr);
        if (!extracted.isEmpty()) {
            extracted.add((JExpression)ref.getParent());
            JMultiExpression multiExpression = new JMultiExpression(sourceInfo, extracted);
            JNode parent = ref.getParent();
            assert (parent != null);
            tr.append(new Replace(parent, multiExpression));
        }
        return new JFieldRef(sourceInfo, newInstance, ref.getFieldId(), ref.getReceiverType());
    }

    @Nonnull
    private JArrayRef extractInstanceAndIndex(@Nonnull JArrayRef ref, @Nonnull TransformationRequest tr) {
        SourceInfo sourceInfo = ref.getSourceInfo();
        ArrayList<JExpression> extracted = new ArrayList<JExpression>();
        JExpression newInstance = this.extract(extracted, ref.getInstance(), tr);
        JExpression newIndex = this.extract(extracted, ref.getIndexExpr(), tr);
        if (!extracted.isEmpty()) {
            extracted.add((JExpression)ref.getParent());
            JMultiExpression multiExpression = new JMultiExpression(sourceInfo, extracted);
            JNode parent = ref.getParent();
            assert (parent != null);
            tr.append(new Replace(parent, multiExpression));
        }
        assert (newInstance != null);
        assert (newIndex != null);
        return new JArrayRef(sourceInfo, newInstance, newIndex);
    }

    @Nonnull
    public JExpression copyWithoutSideEffects(@Nonnull JExpression toCopy, @Nonnull TransformationRequest tr) {
        SourceInfo sourceInfo = toCopy.getSourceInfo();
        if (toCopy instanceof JParameterRef) {
            JParameter a = ((JParameterRef)toCopy).getParameter();
            return a.makeRef(sourceInfo);
        }
        if (toCopy instanceof JLocalRef) {
            JLocal a = ((JLocalRef)toCopy).getLocal();
            return a.makeRef(sourceInfo);
        }
        if (toCopy instanceof JFieldRef) {
            return this.extractInstance((JFieldRef)toCopy, tr);
        }
        if (toCopy instanceof JArrayRef) {
            return this.extractInstanceAndIndex((JArrayRef)toCopy, tr);
        }
        throw new AssertionError((Object)"Not yet supported");
    }
}

