/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.PrebuiltCompatibility;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import java.util.Collections;
import javax.annotation.Nonnull;

@Description(value="Transform synchronization into try/finally with jlock/junlock statement.")
@Name(value="SynchronizeTransformer")
@Constraint(need={NoImplicitBlock.class})
@Transform(remove={JSynchronizedBlock.class, ThreeAddressCodeForm.class}, add={JBlock.class, JTryStatement.class, JTryStatement.FinallyBlock.class, JLock.class, JUnlock.class, JLocalRef.class, JAsgOperation.NonReusedAsg.class, JClassLiteral.class, JThisRef.class, JExpressionStatement.class})
@Use(value={LocalVarCreator.class})
@HasKeyId
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class SynchronizeTransformer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    public static final BooleanPropertyId REUSE_SYNC_VARIABLE = ((BooleanPropertyId)BooleanPropertyId.create("jack.transformation.reusesyncvariable", "Reduce the 'get class' usage in static synchronized methods by reusing a local variable").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);
    private final boolean reuseSyncVariable = ThreadConfig.get(REUSE_SYNC_VARIABLE);
    @Nonnull
    private final JSession session = Jack.getSession();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        LocalVarCreator lvCreator = new LocalVarCreator(method, "sync");
        Visitor visitor = new Visitor(tr, lvCreator);
        visitor.accept(method);
        tr.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final LocalVarCreator lvCreator;

        public Visitor(@Nonnull TransformationRequest tr, LocalVarCreator lvCreator) {
            this.tr = tr;
            this.lvCreator = lvCreator;
        }

        @Override
        public boolean visit(@Nonnull JMethodBody methodBody) {
            JMethod enclosingMethod = methodBody.getMethod();
            if (enclosingMethod.isSynchronized()) {
                JBlock bodyBlock = methodBody.getBlock();
                JTryStatement tryStmt = this.getTryFinally(SourceInfo.UNKNOWN, bodyBlock);
                JDefinedClassOrInterface enclosingType = enclosingMethod.getEnclosingType();
                JExpression lockExpr = null;
                JExpression unlockExpr = null;
                JBlock newBodyBlock = new JBlock(methodBody.getSourceInfo());
                if (SynchronizeTransformer.this.reuseSyncVariable && enclosingMethod.isStatic()) {
                    JLocal syncVar = this.lvCreator.createTempLocal(enclosingType, SourceInfo.UNKNOWN, this.tr);
                    JClassLiteral syncVarValue = new JClassLiteral(SourceInfo.UNKNOWN, enclosingType);
                    JAsgOperation asg = new JAsgOperation(SourceInfo.UNKNOWN, syncVar.makeRef(SourceInfo.UNKNOWN), syncVarValue);
                    newBodyBlock.addStmt(asg.makeStatement());
                    lockExpr = syncVar.makeRef(SourceInfo.UNKNOWN);
                    unlockExpr = syncVar.makeRef(SourceInfo.UNKNOWN);
                } else if (enclosingMethod.isStatic()) {
                    lockExpr = new JClassLiteral(SourceInfo.UNKNOWN, enclosingType);
                    unlockExpr = new JClassLiteral(SourceInfo.UNKNOWN, enclosingType);
                } else {
                    assert (enclosingType instanceof JDefinedClass);
                    JThis thisVar = enclosingMethod.getThis();
                    assert (thisVar != null);
                    lockExpr = ((JVariable)thisVar).makeRef(SourceInfo.UNKNOWN);
                    unlockExpr = ((JVariable)thisVar).makeRef(SourceInfo.UNKNOWN);
                }
                newBodyBlock.addStmt(new JLock(SourceInfo.UNKNOWN, lockExpr));
                newBodyBlock.addStmt(tryStmt);
                JBlock finallyBlock = tryStmt.getFinallyBlock();
                assert (finallyBlock != null);
                finallyBlock.addStmt(new JUnlock(SourceInfo.UNKNOWN, unlockExpr));
                this.tr.append(new Replace(bodyBlock, newBodyBlock));
            }
            return super.visit(methodBody);
        }

        @Override
        public boolean visit(@Nonnull JSynchronizedBlock syncBlock) {
            SourceInfo srcInfo = syncBlock.getSourceInfo();
            JBlock bodyBlock = syncBlock.getSynchronizedBlock();
            JTryStatement tryStmt = this.getTryFinally(srcInfo, bodyBlock);
            JExpression lockExpr = syncBlock.getLockExpr();
            JType lockExprType = lockExpr.getType();
            JLocal syncVar = this.lvCreator.createTempLocal(lockExprType, srcInfo, this.tr);
            JLocalRef asgLhs = syncVar.makeRef(srcInfo);
            JAsgOperation asg = new JAsgOperation(srcInfo, asgLhs, lockExpr);
            JBlock finallyBlock = tryStmt.getFinallyBlock();
            assert (finallyBlock != null);
            finallyBlock.addStmt(new JUnlock(SourceInfo.UNKNOWN, syncVar.makeRef(srcInfo)));
            this.tr.append(new AppendBefore(syncBlock, asg.makeStatement()));
            this.tr.append(new AppendBefore(syncBlock, new JLock(srcInfo, syncVar.makeRef(srcInfo))));
            this.tr.append(new Replace(syncBlock, tryStmt));
            return super.visit(syncBlock);
        }

        @Nonnull
        private JTryStatement getTryFinally(@Nonnull SourceInfo mthSrcInfo, @Nonnull JBlock bodyBlock) {
            JBlock finallyBlock = new JBlock(mthSrcInfo);
            JTryStatement tryStmt = new JTryStatement(mthSrcInfo, Collections.emptyList(), bodyBlock, Collections.emptyList(), finallyBlock);
            return tryStmt;
        }

        @Nonnull
        private JClass getJLClass() {
            return SynchronizeTransformer.this.session.getPhantomLookup().getClass(CommonTypes.JAVA_LANG_CLASS);
        }
    }
}

