/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.google.common.collect.Ordering;
import com.android.jack.ir.SideEffectOperation;
import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.JMethodWithReturnLookupException;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.ast.inner.GetterMarker;
import com.android.jack.transformations.ast.inner.SetterMarker;
import com.android.jack.transformations.ast.inner.WrapperMarker;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Generate accessors for outer fields and methods in an inner class")
@Synchronized
@Transform(add={GetterMarker.class, SetterMarker.class, WrapperMarker.class, JMethodCall.class, JNewInstance.class, JNullLiteral.class, JExpressionStatement.class}, remove={ThreeAddressCodeForm.class, NewInstanceRemoved.class})
@Constraint(no={SideEffectOperation.class, JAlloc.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
@ExclusiveAccess(value=JSession.class)
public class InnerAccessorGenerator
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    static final String THIS_PARAM_NAME = NamingTools.getNonSourceConflictingName("this");
    @Nonnull
    TypePackageAndMethodFormatter formatter = Jack.getLookupFormatter();
    @Nonnull
    private final Ordering<JMethod> methodOrdering = Ordering.from(new Comparator<JMethod>(){

        @Override
        public int compare(@Nonnull JMethod m1, @Nonnull JMethod m2) {
            return InnerAccessorGenerator.this.formatter.getName(m1).compareTo(InnerAccessorGenerator.this.formatter.getName(m2));
        }
    });
    @Nonnull
    private final Ordering<JClassOrInterface> typeOrdering = Ordering.from(new Comparator<JClassOrInterface>(){

        @Override
        public int compare(@Nonnull JClassOrInterface t1, @Nonnull JClassOrInterface t2) {
            return InnerAccessorGenerator.this.formatter.getName(t1).compareTo(InnerAccessorGenerator.this.formatter.getName(t2));
        }
    });

    protected void handleOuterFieldWrite(@Nonnull TransformationRequest tr, @Nonnull JFieldRef fieldRef, @Nonnull JDefinedClassOrInterface accessorClass) {
        SetterMarker newMarker;
        JField field = fieldRef.getFieldId().getField();
        assert (field != null);
        SetterMarker marker = accessorClass.getMarker(SetterMarker.class);
        if (marker == null && (marker = accessorClass.addMarkerIfAbsent(newMarker = new SetterMarker())) == null) {
            marker = newMarker;
        }
        JMethod setter = marker.getOrCreateSetter(field, (JDefinedClass)accessorClass, tr);
        JBinaryOperation binOp = (JBinaryOperation)fieldRef.getParent();
        assert (binOp != null);
        JMethodId setterId = setter.getMethodId();
        JMethodCall setterCall = new JMethodCall(binOp.getSourceInfo(), null, accessorClass, setterId, setterId.getMethodIdWide().canBeVirtual());
        if (!field.isStatic()) {
            JExpression instance = fieldRef.getInstance();
            assert (instance != null);
            setterCall.addArg(instance);
        }
        setterCall.addArg(binOp.getRhs());
        tr.append(new Replace(binOp, setterCall));
    }

    protected void handleOuterFieldRead(@Nonnull TransformationRequest tr, @Nonnull JFieldRef fieldRef, @Nonnull JDefinedClassOrInterface accessorClass) {
        GetterMarker newMarker;
        JField field = fieldRef.getFieldId().getField();
        assert (field != null);
        GetterMarker marker = accessorClass.getMarker(GetterMarker.class);
        if (marker == null && (marker = accessorClass.addMarkerIfAbsent(newMarker = new GetterMarker())) == null) {
            marker = newMarker;
        }
        JMethod getter = marker.getOrCreateGetter(field, (JDefinedClass)accessorClass, tr);
        JMethodId getterId = getter.getMethodId();
        JMethodCall getterCall = new JMethodCall(fieldRef.getSourceInfo(), null, accessorClass, getterId, getterId.getMethodIdWide().canBeVirtual());
        if (!field.isStatic()) {
            JExpression instance = fieldRef.getInstance();
            assert (instance != null);
            getterCall.addArg(instance);
        }
        tr.append(new Replace(fieldRef, getterCall));
    }

    protected void handleOuterMethodCall(@Nonnull TransformationRequest tr, @Nonnull JMethodCall methodCall, @Nonnull JMethod method, @Nonnull JDefinedClassOrInterface accessorClass, boolean isSuper) {
        WrapperMarker newMarker;
        WrapperMarker marker = accessorClass.getMarker(WrapperMarker.class);
        if (marker == null && (marker = accessorClass.addMarkerIfAbsent(newMarker = new WrapperMarker())) == null) {
            marker = newMarker;
        }
        JMethod wrapper = marker.getOrCreateWrapper(method, (JDefinedClass)accessorClass, isSuper, methodCall.getReceiverType());
        JMethodCall wrapperCall = null;
        SourceInfo sourceInfo = methodCall.getSourceInfo();
        if (methodCall instanceof JNewInstance) {
            assert (wrapper instanceof JConstructor);
            wrapperCall = new JNewInstance(sourceInfo, wrapper.getEnclosingType(), wrapper.getMethodId());
        } else {
            JMethodId wrapperId = wrapper.getMethodId();
            if (!method.isStatic() && !(wrapper instanceof JConstructor)) {
                wrapperCall = new JMethodCall(sourceInfo, null, accessorClass, wrapperId, wrapperId.getMethodIdWide().canBeVirtual());
                JExpression instance = methodCall.getInstance();
                assert (instance != null);
                wrapperCall.addArg(instance);
            } else {
                wrapperCall = new JMethodCall(sourceInfo, methodCall.getInstance(), accessorClass, wrapperId, wrapperId.getMethodIdWide().canBeVirtual());
            }
        }
        for (JExpression arg : methodCall.getArgs()) {
            wrapperCall.addArg(arg);
        }
        if (wrapper instanceof JConstructor) {
            int numberOfParamToAdd = wrapper.getParams().size() - method.getParams().size();
            for (int i = 0; i < numberOfParamToAdd; ++i) {
                wrapperCall.addArg(new JNullLiteral(sourceInfo));
            }
        }
        assert (wrapperCall.getArgs().size() == wrapper.getParams().size());
        tr.append(new Replace(methodCall, wrapperCall));
    }

    @Override
    public synchronized void run(@Nonnull JDefinedClassOrInterface type) {
        if (type.getEnclosingType() != null) {
            return;
        }
        if (type.getMemberTypes().isEmpty()) {
            return;
        }
        new Visitor().accept(type);
    }

    class Visitor
    extends JVisitor {
        @Nonnull
        protected final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
        @CheckForNull
        protected TransformationRequest tr;
        @CheckForNull
        private JDefinedClassOrInterface currentType = null;

        Visitor() {
        }

        @Nonnull
        private JDefinedClassOrInterface getAccessorClassForSuperCall(@Nonnull JDefinedClassOrInterface declaringType) {
            JDefinedClassOrInterface enclosing = this.currentType;
            assert (enclosing != null);
            while (!enclosing.canBeSafelyUpcast(declaringType)) {
                enclosing = (JDefinedClass)enclosing.getEnclosingType();
            }
            return enclosing;
        }

        @Nonnull
        private JDefinedClassOrInterface getAccessorClass(int modifier, @Nonnull JDefinedClassOrInterface declaringType) {
            for (JDefinedClassOrInterface refType = this.currentType; refType != null; refType = (JDefinedClassOrInterface)refType.getEnclosingType()) {
                if (!this.isDirectlyVisibleFrom(modifier, declaringType, refType)) continue;
                return refType;
            }
            assert (JModifier.isPrivate(modifier));
            return declaringType;
        }

        private boolean isDirectlyVisibleFrom(int modifier, @Nonnull JDefinedClassOrInterface declaringType, @Nonnull JDefinedClassOrInterface type) {
            if (JModifier.isPublic(modifier) || declaringType.isSameType(type)) {
                return true;
            }
            if (JModifier.isPrivate(modifier)) {
                return false;
            }
            if (JModifier.isProtected(modifier) && type.canBeSafelyUpcast(declaringType)) {
                return true;
            }
            return declaringType.getEnclosingPackage() == type.getEnclosingPackage();
        }

        @Override
        public boolean visit(@Nonnull JFieldRef x) {
            JNode parent = x.getParent();
            JField field = x.getFieldId().getField();
            if (field != null) {
                JDefinedClassOrInterface accessorClass = this.getAccessorClass(field.getModifier(), field.getEnclosingType());
                assert (this.currentType != null);
                assert (this.tr != null);
                if (!accessorClass.isSameType(this.currentType)) {
                    assert (accessorClass.getSourceInfo().getFileSourceInfo().equals(this.currentType.getSourceInfo().getFileSourceInfo()));
                    if (parent instanceof JAsgOperation && ((JAsgOperation)parent).getLhs() == x) {
                        InnerAccessorGenerator.this.handleOuterFieldWrite(this.tr, x, accessorClass);
                    } else {
                        InnerAccessorGenerator.this.handleOuterFieldRead(this.tr, x, accessorClass);
                    }
                }
            }
            return super.visit(x);
        }

        @Override
        public boolean visit(@Nonnull JMethodCall x) {
            JType returnType;
            JMethod method;
            JClassOrInterface receiverType = x.getReceiverType();
            if (receiverType instanceof JDefinedClass && (method = this.getMethod((JDefinedClassOrInterface)receiverType, (JDefinedClassOrInterface)receiverType, returnType = x instanceof JNewInstance ? JPrimitiveType.JPrimitiveTypeEnum.VOID.getType() : x.getType(), x.getMethodIdWide())) != null) {
                boolean isSuper = x.getDispatchKind() == JMethodCall.DispatchKind.DIRECT && method.getMethodIdWide().getKind() == MethodKind.INSTANCE_VIRTUAL;
                JDefinedClassOrInterface accessorClass = isSuper ? this.getAccessorClassForSuperCall(method.getEnclosingType()) : this.getAccessorClass(method.getModifier(), method.getEnclosingType());
                assert (accessorClass != null);
                assert (this.currentType != null);
                if (!accessorClass.isSameType(this.currentType)) {
                    assert (accessorClass.getSourceInfo().getFileSourceInfo().equals(this.currentType.getSourceInfo().getFileSourceInfo()));
                    assert (this.tr != null);
                    InnerAccessorGenerator.this.handleOuterMethodCall(this.tr, x, method, accessorClass, isSuper);
                }
            }
            return super.visit(x);
        }

        @CheckForNull
        private JMethod getMethod(@Nonnull JDefinedClassOrInterface receiverType, @Nonnull JDefinedClassOrInterface typeToSearchMth, @Nonnull JType returnType, @Nonnull JMethodIdWide mthId) {
            JMethod methodFound;
            try {
                JMethod methodFound2 = typeToSearchMth.getMethod(mthId.getName(), returnType, mthId.getParamTypes());
                if (this.isDirectlyVisibleFrom(methodFound2.getModifier(), methodFound2.getEnclosingType(), receiverType)) {
                    return methodFound2;
                }
            }
            catch (JMethodWithReturnLookupException methodFound2) {
                // empty catch block
            }
            JClass superClass = typeToSearchMth.getSuperClass();
            if (superClass instanceof JDefinedClass && (methodFound = this.getMethod(receiverType, (JDefinedClass)superClass, returnType, mthId)) != null) {
                return methodFound;
            }
            return null;
        }

        @Override
        public boolean visit(@Nonnull JDefinedClassOrInterface type) {
            this.currentType = type;
            this.tr = new TransformationRequest(type);
            for (JMethod method : InnerAccessorGenerator.this.methodOrdering.sortedCopy(type.getMethods())) {
                if (method.isNative() || method.isAbstract() || !this.filter.accept(InnerAccessorGenerator.class, method)) continue;
                this.accept(method);
            }
            assert (this.tr != null);
            this.tr.commit();
            for (JClassOrInterface innerType : InnerAccessorGenerator.this.typeOrdering.sortedCopy(type.getMemberTypes())) {
                if (!(innerType instanceof JDefinedClassOrInterface)) continue;
                this.visit((JDefinedClassOrInterface)innerType);
            }
            return false;
        }
    }
}

