/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.transformations.ast.inner.InnerAccessorGenerator;
import com.android.jack.transformations.request.AppendMethodParam;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.sched.item.AbstractComponent;
import com.android.sched.item.ComposedOf;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;

@ValidOn(value={JDefinedClass.class})
@Description(value="This marker indicates that a field has an associated setter.")
public class SetterMarker
implements Marker {
    @Nonnull
    private static final String SETTER_PREFIX = NamingTools.getNonSourceConflictingName("set");
    @Nonnull
    private static final String VALUE_PARAM_NAME = NamingTools.getNonSourceConflictingName("value");
    @Nonnull
    private final HashMap<JField, JMethod> setters = new HashMap();

    @Nonnull
    Collection<JMethod> getAllSetters() {
        return this.setters.values();
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError((Object)"Not yet supported");
    }

    @Nonnull
    JMethod getOrCreateSetter(@Nonnull JField field, @Nonnull JDefinedClass accessorClass, @Nonnull TransformationRequest tr) {
        JMethod setter = this.setters.get(field);
        if (setter == null) {
            SourceInfo sourceInfo = SourceInfo.UNKNOWN;
            String setterName = SETTER_PREFIX;
            setterName = setterName + field.getName();
            JMethodIdWide id = new JMethodIdWide(setterName, MethodKind.STATIC);
            JType fieldType = field.getType();
            setter = new JMethod(sourceInfo, new JMethodId(id, fieldType), accessorClass, 4104);
            JBlock bodyBlock = new JBlock(sourceInfo);
            JMethodBody body = new JMethodBody(sourceInfo, bodyBlock);
            JParameterRef instance = null;
            if (!field.isStatic()) {
                JParameter thisParam = new JParameter(sourceInfo, InnerAccessorGenerator.THIS_PARAM_NAME, accessorClass, 0, setter);
                tr.append(new AppendMethodParam(setter, thisParam));
                instance = thisParam.makeRef(sourceInfo);
            }
            JParameter value = new JParameter(sourceInfo, VALUE_PARAM_NAME, fieldType, 0, setter);
            tr.append(new AppendMethodParam(setter, value));
            JFieldRef lhs = new JFieldRef(sourceInfo, instance, field.getId(), accessorClass);
            JAsgOperation asgOperation = new JAsgOperation(sourceInfo, lhs, value.makeRef(sourceInfo));
            bodyBlock.addStmt(new JExpressionStatement(sourceInfo, asgOperation));
            JReturnStatement returnSt = new JReturnStatement(sourceInfo, value.makeRef(sourceInfo));
            bodyBlock.addStmt(returnSt);
            setter.setBody(body);
            assert (!this.setters.containsKey(field));
            this.setters.put(field, setter);
        }
        return setter;
    }

    @Name(value="InnerAccessorSetter")
    @Description(value="All JNodes created for a setter allowing to access an inner field.")
    @ComposedOf(value={JMethod.class, JMethodBody.class, JParameter.class, JParameterRef.class, JFieldRef.class, JAsgOperation.NonReusedAsg.class, JReturnStatement.class, JBlock.class})
    static class InnerAccessorSetter
    implements AbstractComponent {
        InnerAccessorSetter() {
        }
    }
}

