/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.formatter.IdentifierFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.transformations.ast.inner.InnerAccessorGenerator;
import com.android.jack.util.NamingTools;
import com.android.sched.item.AbstractComponent;
import com.android.sched.item.ComposedOf;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@ValidOn(value={JDefinedClass.class})
@Description(value="This marker indicates that a method has an associated wrapper.")
public class WrapperMarker
implements Marker {
    @Nonnull
    private static final String WRAPPER_PREFIX = NamingTools.getNonSourceConflictingName("wrap");
    @Nonnull
    private final HashMap<MethodCallDescriptor, JMethod> wrappers = new HashMap();

    @CheckForNull
    private JMethod getWrapper(@Nonnull JMethod method, boolean isStaticDispatchOnly, @Nonnull JClassOrInterface mthCallReceiverType) {
        MethodCallDescriptor descriptor = new MethodCallDescriptor(method, isStaticDispatchOnly, mthCallReceiverType);
        return this.wrappers.get(descriptor);
    }

    private boolean hasSameKeyWithoutReceiverType(@Nonnull MethodCallDescriptor newKey) {
        for (MethodCallDescriptor mcd : this.wrappers.keySet()) {
            if (!mcd.method.equals(newKey.method) || mcd.isSuper != newKey.isSuper) continue;
            return true;
        }
        return false;
    }

    private void addWrapper(@Nonnull JMethod method, @Nonnull JMethod wrapper, boolean isStaticDispatchOnly, @Nonnull JClassOrInterface mthCallReceiverType) {
        MethodCallDescriptor descriptor = new MethodCallDescriptor(method, isStaticDispatchOnly, mthCallReceiverType);
        if (this.hasSameKeyWithoutReceiverType(descriptor)) {
            throw new AssertionError();
        }
        assert (!this.wrappers.containsKey(descriptor));
        this.wrappers.put(descriptor, wrapper);
    }

    @Nonnull
    Collection<JMethod> getAllWrappers() {
        return this.wrappers.values();
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError((Object)"Not yet supported");
    }

    @Nonnull
    JMethod getOrCreateWrapper(@Nonnull JMethod method, @Nonnull JDefinedClass accessorClass, boolean isSuper, @Nonnull JClassOrInterface mthCallReceiverType) {
        JMethod wrapper = this.getWrapper(method, isSuper, mthCallReceiverType);
        if (wrapper == null) {
            SourceInfo sourceInfo = SourceInfo.UNKNOWN;
            boolean isConstructor = method instanceof JConstructor;
            if (isConstructor) {
                wrapper = new JConstructor(sourceInfo, accessorClass, 4096);
            } else {
                String wrapperName = WRAPPER_PREFIX;
                wrapperName = wrapperName + IdentifierFormatter.getFormatter().getName(mthCallReceiverType) + IdentifierFormatter.getFormatter().getName(method) + isSuper;
                wrapper = new JMethod(sourceInfo, new JMethodId(new JMethodIdWide(wrapperName, MethodKind.STATIC), method.getType()), accessorClass, 4104);
            }
            JVariableRef instance = null;
            JMethodIdWide id = wrapper.getMethodIdWide();
            if (isConstructor) {
                JThis jThis = wrapper.getThis();
                assert (jThis != null);
                instance = jThis.makeRef(sourceInfo);
            } else if (!method.isStatic()) {
                JParameter thisParam = new JParameter(sourceInfo, InnerAccessorGenerator.THIS_PARAM_NAME, accessorClass, 0, wrapper);
                wrapper.addParam(thisParam);
                id.addParam(accessorClass);
                instance = thisParam.makeRef(sourceInfo);
            }
            JMethodId calledMethodId = method.getMethodId();
            JMethodCall methodCall = new JMethodCall(sourceInfo, instance, mthCallReceiverType, calledMethodId, calledMethodId.getMethodIdWide().canBeVirtual() && !isSuper);
            for (JParameter param : method.getParams()) {
                JType paramType = param.getType();
                JParameter newParam = new JParameter(sourceInfo, param.getName(), paramType, 0, wrapper);
                wrapper.addParam(newParam);
                id.addParam(paramType);
                methodCall.addArg(newParam.makeRef(sourceInfo));
            }
            if (isConstructor) {
                while (this.constructorExists((JConstructor)wrapper, accessorClass)) {
                    JParameter newParam = new JParameter(sourceInfo, InnerAccessorGenerator.THIS_PARAM_NAME + wrapper.getParams().size(), accessorClass, 0, wrapper);
                    wrapper.addParam(newParam);
                    id.addParam(accessorClass);
                }
            }
            JBlock bodyBlock = new JBlock(sourceInfo);
            JMethodBody body = new JMethodBody(sourceInfo, bodyBlock);
            assert (methodCall.getArgs().size() == methodCall.getMethodIdWide().getParamTypes().size());
            if (method.getType() == JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()) {
                bodyBlock.addStmt(methodCall.makeStatement());
                bodyBlock.addStmt(new JReturnStatement(sourceInfo, null));
            } else {
                bodyBlock.addStmt(new JReturnStatement(sourceInfo, methodCall));
            }
            wrapper.setBody(body);
            this.addWrapper(method, wrapper, isSuper, mthCallReceiverType);
        }
        return wrapper;
    }

    private boolean constructorExists(@Nonnull JConstructor wrapper, @Nonnull JDefinedClass accessorClass) {
        for (JMethod method : accessorClass.getMethods()) {
            if (!(method instanceof JConstructor) || !this.hasSameArgumentType(wrapper, (JConstructor)method)) continue;
            return true;
        }
        for (JMethod method : this.getAllWrappers()) {
            if (!(method instanceof JConstructor) || !this.hasSameArgumentType(wrapper, (JConstructor)method)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameArgumentType(@Nonnull JMethod wrapper, @Nonnull JConstructor method) {
        List<JParameter> wrapperParams = wrapper.getParams();
        List<JParameter> methodParams = method.getParams();
        int size = wrapperParams.size();
        if (size != methodParams.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (wrapperParams.get(i).getType().isSameType(methodParams.get(i).getType())) continue;
            return false;
        }
        return true;
    }

    @Name(value="InnerAccessorWrapper")
    @Description(value="All JNodes created for a wrapper allowing to access an inner method.")
    @ComposedOf(value={JMethod.class, JConstructor.class, JThisRef.class, JParameter.class, JParameterRef.class, JMethodCall.class, JMethodBody.class, JReturnStatement.class, JBlock.class})
    static class InnerAccessorWrapper
    implements AbstractComponent {
        InnerAccessorWrapper() {
        }
    }

    private static class MethodCallDescriptor {
        @Nonnull
        private final JMethod method;
        private final boolean isSuper;
        @Nonnull
        private final JClassOrInterface mthCallReceiverType;

        private MethodCallDescriptor(@Nonnull JMethod method, boolean isSuper, @Nonnull JClassOrInterface mthCallReceiverType) {
            this.method = method;
            this.isSuper = isSuper;
            this.mthCallReceiverType = mthCallReceiverType;
        }

        public final boolean equals(@CheckForNull Object obj) {
            if (obj instanceof MethodCallDescriptor) {
                MethodCallDescriptor toCompare = (MethodCallDescriptor)obj;
                return this.method.equals(toCompare.method) && this.isSuper == toCompare.isSuper && this.mthCallReceiverType.isSameType(toCompare.mthCallReceiverType);
            }
            return false;
        }

        public final int hashCode() {
            int hashCode = this.method.hashCode() ^ this.mthCallReceiverType.hashCode();
            return 31 * hashCode + Boolean.valueOf(this.isSuper).hashCode();
        }
    }
}

