/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.jack.ir.naming.CompositeName;
import com.android.jack.ir.naming.TypeName;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JLookupException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.signature.GenericSignatureAction;
import com.android.jack.util.NamingTools;
import com.android.sched.schedulable.Constraint;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={OriginalNames.class})
public class GenericSignatureRefiner
implements GenericSignatureAction<JType> {
    @CheckForNull
    private CharSequence refinedSequence = null;
    @Nonnull
    private StringBuilder strBuf = new StringBuilder();
    @Nonnull
    private final JLookup jlookup;
    @Nonnull
    private final TypeFormatter formatter = BinaryQualifiedNameFormatter.getFormatter();

    public GenericSignatureRefiner() {
        this.jlookup = Jack.getSession().getLookup();
    }

    @Override
    public void parsedSymbol(char symbol) {
        this.strBuf.append(symbol);
    }

    @Override
    public void parsedIdentifier(@Nonnull String identifier) {
        this.strBuf.append(identifier);
    }

    @Override
    @CheckForNull
    public JType parsedTypeName(@Nonnull String name) {
        this.updateRefinedSequence(this.getStringFromBuffer());
        try {
            JType type = this.jlookup.getType(NamingTools.getTypeSignatureName(name));
            this.updateRefinedSequence(new TypeName(TypeName.Kind.BINARY_QN, type));
            return type;
        }
        catch (JLookupException e) {
            this.updateRefinedSequence(name);
            return null;
        }
    }

    @Override
    @CheckForNull
    public JType parsedInnerTypeName(@CheckForNull JType enclosingType, @Nonnull String name) {
        this.updateRefinedSequence(this.getStringFromBuffer());
        if (enclosingType != null) {
            try {
                char c;
                JType type = this.jlookup.getType(NamingTools.getTypeSignatureName(this.formatter.getName(enclosingType) + '$' + name));
                int index = 0;
                while (Character.isDigit(c = name.charAt(index))) {
                    this.strBuf.append(c);
                    if (++index < name.length()) continue;
                }
                this.updateRefinedSequence(new TypeName(TypeName.Kind.SIMPLE_NAME, type));
                return type;
            }
            catch (JLookupException jLookupException) {
                // empty catch block
            }
        }
        this.updateRefinedSequence(name);
        return null;
    }

    @Override
    public void start() {
        this.strBuf = new StringBuilder();
        this.refinedSequence = null;
    }

    @Override
    public void stop() {
        this.updateRefinedSequence(this.getStringFromBuffer());
    }

    @Nonnull
    public CharSequence getNewSignature() {
        assert (this.refinedSequence != null);
        return this.refinedSequence;
    }

    @Nonnull
    private String getStringFromBuffer() {
        StringBuilder oldBuffer = this.strBuf;
        this.strBuf = new StringBuilder();
        return oldBuffer.toString();
    }

    private void updateRefinedSequence(@Nonnull CharSequence newSequence) {
        if (this.refinedSequence == null) {
            this.refinedSequence = newSequence;
        } else if (newSequence.length() > 0) {
            assert (this.refinedSequence != null);
            this.refinedSequence = new CompositeName(this.refinedSequence, newSequence);
        }
    }
}

