/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.switches;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBreakStatement;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.scheduling.feature.SourceVersion7;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.ControlFlowHelper;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Transforms switches using strings into \"if\" statements")
@Constraint(need={JSwitchStatement.class, JCaseStatement.class}, no={JBreakStatement.class})
@Transform(add={JLabeledStatement.class, JLabel.class, JBlock.class, JMethodCall.class, JGoto.class, JIfStatement.class, JLocalRef.class, JAsgOperation.class}, remove={JSwitchStatement.SwitchWithString.class})
@Use(value={LocalVarCreator.class})
@Support(value={SourceVersion7.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class SwitchStringSupport
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JMethodId equalsMethodId;

    public SwitchStringSupport() {
        JSession session = Jack.getSession();
        JPhantomLookup lookup = session.getPhantomLookup();
        JClass jlo = lookup.getClass(CommonTypes.JAVA_LANG_OBJECT);
        JClass jls = lookup.getClass(CommonTypes.JAVA_LANG_STRING);
        this.equalsMethodId = jls.getMethodId("equals", Collections.singletonList(jlo), MethodKind.INSTANCE_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType());
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr, method);
        visitor.accept(method);
        tr.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final LocalVarCreator localVarCreator;
        @Nonnegative
        private int switchCount = 0;

        public Visitor(@Nonnull TransformationRequest tr, JMethod method) {
            this.tr = tr;
            this.localVarCreator = new LocalVarCreator(method, "switch_var_");
        }

        @Override
        public boolean visit(@Nonnull JStatement stmt) {
            return super.visit(stmt);
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            if (this.switchHasString(switchStmt)) {
                assert (this.allCasesAreStrings(switchStmt));
                SourceInfo dbgInfo = switchStmt.getSourceInfo();
                JLocal tempLocal = this.localVarCreator.createTempLocal(switchStmt.getExpr().getType(), dbgInfo, this.tr);
                JAsgOperation asg = new JAsgOperation(dbgInfo, tempLocal.makeRef(dbgInfo), switchStmt.getExpr());
                this.tr.append(new AppendBefore(switchStmt, asg.makeStatement()));
                for (JCaseStatement caseStmt : switchStmt.getCases()) {
                    JAbstractStringLiteral caseExpr = (JAbstractStringLiteral)caseStmt.getExpr();
                    assert (caseExpr != null);
                    caseExpr.setSourceInfo(dbgInfo);
                    JLabeledStatement labelStmt = new JLabeledStatement(dbgInfo, new JLabel(dbgInfo, "label_" + caseExpr.getValue() + "_" + this.switchCount), new JBlock(dbgInfo));
                    this.tr.append(new Replace(caseStmt, labelStmt));
                    JMethodCall equalsCall = new JMethodCall(dbgInfo, tempLocal.makeRef(dbgInfo), (JClassOrInterface)switchStmt.getExpr().getType(), SwitchStringSupport.this.equalsMethodId, true);
                    equalsCall.addArg(caseExpr);
                    JBlock thenBlock = new JBlock(dbgInfo);
                    thenBlock.addStmt(new JGoto(dbgInfo, labelStmt));
                    JIfStatement ifStmt = new JIfStatement(dbgInfo, equalsCall, thenBlock, null);
                    this.tr.append(new AppendBefore(switchStmt, ifStmt));
                }
                JCaseStatement defaultCase = switchStmt.getDefaultCase();
                JLabeledStatement defaultLabelStmt = new JLabeledStatement(dbgInfo, new JLabel(SourceInfo.UNKNOWN, "label_default_" + this.switchCount), new JBlock(SourceInfo.UNKNOWN));
                this.tr.append(new AppendBefore(switchStmt, new JGoto(dbgInfo, defaultLabelStmt)));
                if (defaultCase != null) {
                    this.tr.append(new Replace(defaultCase, defaultLabelStmt));
                } else {
                    JStatement nextStatement = ControlFlowHelper.getNextStatement(switchStmt);
                    assert (nextStatement != null);
                    this.tr.append(new AppendBefore(nextStatement, defaultLabelStmt));
                }
                this.tr.append(new Replace(switchStmt, switchStmt.getBody()));
                ++this.switchCount;
            }
            return super.visit(switchStmt);
        }

        private boolean switchHasString(@Nonnull JSwitchStatement switchStmt) {
            List<JCaseStatement> cases = switchStmt.getCases();
            return cases.size() > 0 && cases.get(0).getExpr() instanceof JAbstractStringLiteral;
        }

        private boolean allCasesAreStrings(@Nonnull JSwitchStatement switchStmt) {
            List<JCaseStatement> cases = switchStmt.getCases();
            for (JCaseStatement caseStmt : cases) {
                JLiteral caseExpr = caseStmt.getExpr();
                if (caseExpr instanceof JAbstractStringLiteral) continue;
                return false;
            }
            return cases.size() > 0;
        }
    }
}

