/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.booleanoperators;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JConditionalOperation;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.SanityChecks;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Checks that conditional boolean operators && and || have been removed")
@Constraint(no={JConditionalOperation.class})
@Support(value={SanityChecks.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ConditionalAndOrRemoverChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ConditionalAndOrRemoverCheckerVisitor bescv = new ConditionalAndOrRemoverCheckerVisitor();
        bescv.accept(method);
    }

    private static class ConditionalAndOrRemoverCheckerVisitor
    extends JVisitor {
        private ConditionalAndOrRemoverCheckerVisitor() {
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binOp) {
            super.visit(binOp);
            if (binOp.getOp() == JBinaryOperator.AND || binOp.getOp() == JBinaryOperator.OR) {
                throw new AssertionError((Object)("Conditional operator found : " + binOp.toSource()));
            }
            return true;
        }
    }
}

